package com.mingsoft.entity;

/**
 *  Comments:servlet信息返回信息实体 
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public class ResutEntity {

	/**
	 * 登录成功
	 */
	public final static int LOGIN_SUCCESS = 100;

	/**
	 * 用户名错误
	 */
	public final static int LOGIN_USRENAME_ERROR = 101;

	/**
	 * 密码错误
	 */
	public final static int LOGIN_PASSWORD_ERROR = 102;

	/**
	 * 验证码错误
	 */
	public final static int LOGIN_RANDCODER_ERROR = 103;

	/**
	 * 用户名或密码空值错误
	 */
	public final static int LOGIN_EMPTY = 104;
	
	/**
	 * 验证码空值错误
	 */
	public final static int LOGIN_RANDCODER_EMPTY = 105;
	
	/**
	 * 密码修改成功
	 */
	public final static int PASSWORD_EDIT_SUCCESS = 106;
	
	/**
	 * 旧密码输入错误
	 */
	public final static int OLD_PASSWORD_ERROE = 107;

	/**
	 * 新密码不能为空
	 */
	public final static int NEW_PASSWORD_CANNOT_EMPTY = 118;
	
	/**
	 * 密码长度为5—18
	 */
	public final static int PASSWORD_LENGTH = 119;
	
	/**
	 * 两次输入的新密码不一致
	 */
	public final static int NEW_PASSWORD_DISACCORD = 108;
	
	/**
	 * 网站标题不能为空
	 */
	public final static int WEBTITLE_CANNOT_EMPTY = 111;

	/**
	 * 标题长度为5—18个字符
	 */
	public final static int WEBTITLE_LENGTH = 120;
	
	/**
	 * 网站域名不能为空
	 */
	public final static int WEBREALMNAME_CANNOT_EMPTY = 112;
	
	/**
	 * 网站信息修改成功
	 */
	public final static int WEBINFO_EDIT_SUCCESS = 109;
	
	/**
	 * 网站LOGO删除成功
	 */
	public final static int WEBLOGO_DELETE_SUCCESS = 110;
	
	/**
	 * 该类型下没有文章
	 */
	public final static int ARTICLE_NULL = 201;
	
	/**
	 * 该类型下已经有文章
	 */
	public final static int ARTICLE_EXIST = 202;
	
	/**
	 * 请先删除该栏目下的文章
	 */
	public final static int ARTICLETYPE_REMOVE_FAIL = 301;
	
	/**
	 * 删除成功
	 */
	public final static int ARTICLETYPE_REMOVE_SUCCESS = 302;
	
	/**
	 * 模版路径没找到
	 */
	public final static int TEMPLET_NO_EXISTS = 303;
	
	/**
	 * 主页生成成功
	 */
	public final static int HOMEPAGE_CREATED = 304;
	
	/**
	 * 数据库主机
	 */
	public final static int INSTALL_DBHOST = 101;
	
	/**
	 * 数据库名称
	 */
	public final static int INSTALL_DBNAME = 102;
	
	/**
	 * 数据库用户名
	 */
	public final static int INSTALL_DBUSER= 103;
	
	/**
	 * 数据库驱动
	 */
	public final static int INSTALL_DB_DRIVER = 104;
	
	/**
	 * 没有该数据库名称
	 */
	public final static int INSTALL_DB_NODB = 105;
	
	/**
	 * 数据库用户密码错误
	 */
	public final static int INSTALL_DB_NOUSER= 106;
	
	/**
	 * 数据库用户密码错误
	 */
	public final static int INSTALL_DB_JDBC= 107;
	
	/**
	 * 数据库更新完成跳转页面
	 */
	public final static int FORWARD_THIRD= 109;
	
	/**
	 * 返回编码
	 */
	private int code;

	/**
	 * 返回提示信息内容
	 */
	private String content;

	/**
	 * 信息返回后需要跳转的地址
	 */
	private String url;

	public int getCode() {
		return code;
	}

	public String getContent() {
		return content;
	}

	public String getUrl() {
		return url;
	}

	/**
	 * 100:登录成功 101:用户名错误 102:密码错误 103:验证码错误 104:用户名和密码空值错误 105:验证码空值错误
	 * 106:密码修改成功 107:旧密码输入错误 108:两次输入的新密码不一致 109:网站信息不能为空 110:请选择网站LOGO
	 * 111:网站信息修改成功
	 * @param code  错误码
	 */
	public void setCode(int code) {
		this.code = code;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public void setUrl(String url) {
		this.url = url;
	}

}
