package com.mingsoft.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.constant.SessionConst;
import com.mingsoft.entity.UserEntity;

/**
 * 管理员过滤器 
 * 	通过session进行对登录对象进行判断
 * 	对象的属性不为空则证明已经登录 跳转到相应的页面 否则跳转到登录页面	
 * @author 荣繁奎rfk
 *
 */
public class AdminFilter implements Filter {

	public void destroy() {
		
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		//判断session 去request对象进行强制转换
		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse resp = (HttpServletResponse) response;
		//通过枚举类  获取session对象
		Object obj = req.getSession().getAttribute(SessionConst.ADMIN_SESSION.toString());
		if (obj!=null) {
			//对象强制转换 对象肯定为	UserEntity类
			UserEntity user = (UserEntity)obj;
			//如果对象的属性不为空 证明已经登录 可以跳转到用户相应页面 否则跳转到登录页面
			if (user.getUserName()!="") {
				chain.doFilter(request, response);
			}
		} else {
			 resp.sendRedirect(req.getContextPath() + "/login");
		}
	}

	public void init(FilterConfig arg0) throws ServletException {
		
	}

}
