package com.mingsoft.io;

import java.io.*;
import java.util.List;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;

/**
 * 编写 生成html页面文件保存在html文件夹下面，对应html模板页面名级目录
 * @author 荣繁奎
 *	QQ:1096199590
 *  铭飞科技
 *  官网 www.ming-soft.com
 */
public class CreateHtmlFile {
	
	/**
	 * 创建生成html页面，并返回静态html路径
	 * @param projectUrl 项目的物理路径
	 * @param htmlContent 解析完成后的HTML代码
	 * @param pathUrl HTML模版的相对路径
	 * @param articleId 获取用户需要查看的文章ID，默认为0时不存在
	 * @param articleTypeId  获取用户需要查看的栏目ID，默认为0时不存在
	 * @return 生成页面的路径
	 */
	@Deprecated
	public static String createHtml(String projectUrl,String htmlContent,String pathUrl,int articleId,int articleTypeId) {
		String htmlUrl = RegexConstant.HTML_TAG+pathBulid(articleId,articleTypeId);
		int htmlName = 0;
		if(articleId != 0 && articleTypeId == 0){
			htmlName = articleId;
		}else if(articleTypeId != 0 && articleId ==0){
			htmlName = articleTypeId;
		}
		// 创建生成html页面路径
		String articlePath = projectUrl +JspPage.PATH_SYMBOL+htmlUrl;
		File f = null;
		try {
			// 创建File判断文件夹是否存在
			f = new File(articlePath);
			if (!f.exists()) {
				// 不存在创建文件目录
				f.mkdirs();
			}
			// 创建文件
			f = new File(articlePath + htmlName + ".html");
			//如果已经存在则首先删除再进行创建文件
			if(f.exists()){
				f.delete();
			}
			f.createNewFile();
			// 創建寫入流向文件寫入內容
			OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(f.getPath()), "utf-8");
			BufferedWriter reader = new BufferedWriter(osw);
			reader.write(htmlContent);
			reader.close();
			osw.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		// 给返回路径添加文件名
		htmlUrl = htmlUrl +htmlName + "." + RegexConstant.HTML_TAG;
		return htmlUrl;
	}
	
	
	/**
	 * 根据文章的id进行查询typeid组合成 静态页面的生成路径
	 * @param articleId 文章的id
	 * @return String 静态页面的路径名
	 * 路径规则 /n/n/
	 */
	public static String pathBulid(int articleId,int articleTypeId){
		//栏目ID
		int articleTypeIdPaty = 0;
		//根据文章ID找出相应的栏目ID
		if(articleId != 0 && articleTypeId == 0){
			ArticleEntity article = new ArticleEntity();
			IArticleBiz articleBiz = new ArticleBizImpl();
			article.setArticleId(articleId);
			article = articleBiz.selectEntity(article);
			articleTypeIdPaty = article.getArticleType();
			String realPath = realPath(articleTypeIdPaty);
			String articlePaty = JspPage.PATH_SYMBOL+realPath+articleTypeIdPaty+JspPage.PATH_SYMBOL;
			if(realPath.equals(JspPage.PATH_SYMBOL)){
				articlePaty = JspPage.PATH_SYMBOL+articleTypeIdPaty+JspPage.PATH_SYMBOL;
			}
			return articlePaty;
		} else if(articleTypeId != 0 && articleId == 0){
			articleTypeIdPaty = articleTypeId;		
			String realPath = realPath(articleTypeIdPaty);
			
			String articleTypePaty = JspPage.PATH_SYMBOL+realPath;
			if(realPath.equals(JspPage.PATH_SYMBOL)){
				articleTypePaty = JspPage.PATH_SYMBOL;
			}
			return articleTypePaty;
		}else {
			return RegexConstant.URL_STRUCTURE_ERRO;
		}
	}
	
	/**
	 * 封面的路径
	 * @param articleTyepId 栏目的id
	 * @return 路径
	 */
	public static String pathArticleType(int articleTyepId){
		String realPath = realPath(articleTyepId);
		String articleTypePaty = JspPage.PATH_SYMBOL+realPath;
		if(realPath.equals(JspPage.PATH_SYMBOL)){
			articleTypePaty = JspPage.PATH_SYMBOL;
		}
		return articleTypePaty;
	}
	
	/**
	 * 创建生成html页面，并返回静态html路径
	 * @param projectUrl 项目的物理路径
	 * @param htmlContent 解析完成后的HTML代码
	 * @param pathUrl HTML模版的相对路径
	 * @param article 文章的实体类
	 * @return 生成页面的路径
	 */
	public static String createArticleHtml(String projectUrl,String htmlContent,String pathUrl,ArticleEntity article){
		String htmlUrl = RegexConstant.HTML_TAG+pathBulidForArticle(article);
		int htmlName = article.getArticleId();
		// 创建生成html页面路径
		String articlePath = projectUrl +JspPage.PATH_SYMBOL+htmlUrl;
		File f = null;
		try {
			// 创建File判断文件夹是否存在
			f = new File(articlePath);
			if (!f.exists()) {
				// 不存在创建文件目录
				f.mkdirs();
			}
			// 创建文件
			f = new File(articlePath + htmlName + ".html");
			//如果已经存在则首先删除再进行创建文件
			if(f.exists()){
				f.delete();
			}
			f.createNewFile();
			// 創建寫入流向文件寫入內容
			OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(f.getPath()), "utf-8");
			BufferedWriter reader = new BufferedWriter(osw);
			reader.write(htmlContent);
			reader.close();
			osw.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		// 给返回路径添加文件名
		htmlUrl = htmlUrl +htmlName + "." + RegexConstant.HTML_TAG;
		return htmlUrl;
	}
	
	/**
	 * 根据文章实体类进行组建文章的路径
	 * @param article 文章实体类
	 * @return 路径 n/n/12/
	 */
	public static String pathBulidForArticle(ArticleEntity article){
			int articleTypeIdPaty = article.getArticleType();
			String realPath = realPath(articleTypeIdPaty);
			String articlePaty = JspPage.PATH_SYMBOL+realPath+articleTypeIdPaty+JspPage.PATH_SYMBOL;
			if(realPath.equals(JspPage.PATH_SYMBOL)){
				articlePaty = JspPage.PATH_SYMBOL+articleTypeIdPaty+JspPage.PATH_SYMBOL;
			}
			return articlePaty;
	}
	
	/**
	 * 创建生成html页面，并返回静态html路径
	 * @param projectUrl 项目的物理路径
	 * @param htmlContent 解析完成后的HTML代码
	 * @param pathUrl HTML模版的相对路径
	 * @param article 栏目id
	 * @return 生成页面的路径
	 */
	public static String createArticleTypeHtml(String projectUrl,String htmlContent,String pathUrl,int articleTypeId) {
			String htmlUrl = RegexConstant.HTML_TAG+pathArticleType(articleTypeId);
			// 创建生成html页面路径
			String articlePath = projectUrl +JspPage.PATH_SYMBOL+htmlUrl;
			File f = null;
			try {
				// 创建File判断文件夹是否存在
				f = new File(articlePath);
				if (!f.exists()) {
					// 不存在创建文件目录
					f.mkdirs();
				}
				// 创建文件
				f = new File(articlePath + articleTypeId + ".html");
				//如果已经存在则首先删除再进行创建文件
				if(f.exists()){
					f.delete();
				}
				f.createNewFile();
				// 創建寫入流向文件寫入內容
				OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(f.getPath()), "utf-8");
				BufferedWriter reader = new BufferedWriter(osw);
				reader.write(htmlContent);
				reader.close();
				osw.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
			// 给返回路径添加文件名
			htmlUrl = htmlUrl +articleTypeId + "." + RegexConstant.HTML_TAG;
			return htmlUrl;
	}
	
	/**
	 * 根据栏目编号生成路径，
	 * 例：栏目编号为9,N顶级栏目为n
	 * 生成格式: n/n/9/
	 * @param articleTypeId 栏目编号
	 * @return
	 */
	public static String pathArticlTypeBulid(int articleTypeId){
		//为空直接返回
		if (articleTypeId==0) {
			return "";
		}		
		String articleTypeHtmlUrl = JspPage.PATH_SYMBOL+realPath(articleTypeId)+articleTypeId+JspPage.PATH_SYMBOL;
		return articleTypeHtmlUrl;
	}
	
	
	/**
	 * 根据栏目ID确定写入的静态的页面的目录结构
	 * @param articleTypeIdPaty
	 * @return 目录结构
	 */
	private static String realPath(int articleTypeIdPaty){
		IArticleTypeBiz acBiz = new ArticleTypeBizImpl();
		/*
		 * 通过文章的typeid进行查询所在栏目的所有父栏目节点
		 */
		List<ArticleTypeEntity> list =  acBiz.searchTreeTop(articleTypeIdPaty);
		StringBuffer str = new StringBuffer();
		for(int i=0;i<list.size();i++){
			str.append(list.get(i).getArticleTypeId()+JspPage.PATH_SYMBOL);
		}
		//释放内存
		list = null;
		/*
		 * 利用父节点id进行建立路径 反向输出路径
		 */
		String realPath = cutApart(str.toString());
		return realPath;
	}
	
	/**
	 * 利用父节点id进行建立路径 反向输出路径
	 * @param path 反向的路径
	 * @return 正确的路径
	 */
	private static String cutApart(String path){
		String a[] = path.split(JspPage.PATH_SYMBOL);
		StringBuffer str = new StringBuffer();
		for(int i = a.length-1;i>-1;i--){
			str.append(a[i]+JspPage.PATH_SYMBOL);
		}
		String rePath = str.toString();
		return rePath;
	}
}
