package com.mingsoft.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.mingsoft.constant.RegexConstant;
import com.mingsoft.util.StringUtil;

/**
 * 实现类容替换标签方法的抽象类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public abstract class Regex {
	
	public String htmlCotent = null;
	
	public String newCotent = null;
	
	/**
	 * 用该内容替换所有当前标签
	 * @param htmlCotent 源内容
	 * @param newCotent 替换内容
	 * @param regex 替换规则，更具RegexEnum
	 * @return 替换完成的HTML模版
	 */
	public String replaceAll(RegexEnum regex) {
		if(StringUtil.strNull(newCotent)){
			newCotent = RegexConstant.REGEX_ERRO;
			//newCotent=regex.getRegex()+":"+RegexConstant.REGEX_ERRO;
		}
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(htmlCotent);
		if(matcher.find()){
			htmlCotent = matcher.replaceAll(newCotent);
		}
		return htmlCotent;
	}
	
	/**
	 * 用该内容替换第一个当前找到的第一个标签
	 * @param htmlCotent 源内容
	 * @param newCotent 替换内容
	 * @param regex 替换规则，更具RegexEnum
	 * @return 替换完成的HTML模版
	 */
	public String replaceFirst(RegexEnum regex) {
		if(StringUtil.strNull(newCotent)){
			newCotent = RegexConstant.REGEX_ERRO;
		}
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(htmlCotent);
		if(matcher.find()){
			htmlCotent = matcher.replaceFirst(newCotent);
		}
		return htmlCotent;
	}
	
	
	/**
	 * 标签替换的抽象方法
	 * @return 替换完成的HTML模版
	 */
	public abstract String parse();
	
}
