package com.mingsoft.regex.impl;

import java.util.List;
import java.util.Map;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.IWebBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.biz.impl.WebBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.IPrase;
import com.mingsoft.regex.prase.ArticleAuthorPrase;
import com.mingsoft.regex.prase.ArticleContentPrase;
import com.mingsoft.regex.prase.ArticleDatePrase;
import com.mingsoft.regex.prase.ArticleHistoryPrase;
import com.mingsoft.regex.prase.ArticleLinkPrase;
import com.mingsoft.regex.prase.ArticleSourcePrase;
import com.mingsoft.regex.prase.ArticleTitlePrase;
import com.mingsoft.regex.prase.ArticleTypeLinkPrase;
import com.mingsoft.regex.prase.ArticleTypeTitlePrase;
import com.mingsoft.regex.prase.ChannelContPrase;
import com.mingsoft.regex.prase.ChannelPrase;
import com.mingsoft.regex.prase.GlobolCopyrightPrase;
import com.mingsoft.regex.prase.GlobolDescripPrase;
import com.mingsoft.regex.prase.GlobolKeywordPrase;
import com.mingsoft.regex.prase.GlobolLogoPrase;
import com.mingsoft.regex.prase.GlobolNamePrase;
import com.mingsoft.regex.prase.GlobolSkinUrlPrase;
import com.mingsoft.regex.prase.GlobolUrlPrase;
import com.mingsoft.regex.prase.IncludePrase;
import com.mingsoft.regex.prase.ListPrase;
import com.mingsoft.regex.prase.PageNumPrase;
import com.mingsoft.regex.prase.PagePrase;
import com.mingsoft.util.RegexUtil;
import com.mingsoft.util.StringUtil;
/**
 *  替换标签类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class PraseImpl implements IPrase{
	/**
	 * 替换标签的方法
	 */
//	private Regex regex;
	
	/**
	 * 原HTML
	 */
	private String html = null;
	
	/**
	 * 获取分页的动态参数
	 * 数据库中取数据的开始位置
	 */
	private int beginSize = 0;
	
	/**
	 * 原HTML的相对路径
	 */
	private String urlPage;
	
	/**
	 * 获取链接上提交的文章ID
	 */
	private int articleId;
	
	/**
	 * 获取链接上计较的栏目ID
	 */
	private int articleTypeId;
	
	/**
	 * 需要替换的列表文章内容
	 */
//	private IArticleBiz articleBiz = new ArticleBizImpl();
	
	/**
	 * 替换栏目内容
	 */
//	private IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
	
	/**
	 * 构造解析内容的必须值
	 * @param html 还未替换标签的原HTML代码
	 * @param path HTML模版所在的物理路径
	 * @param beginSize 定位使用分页时页面的位置
	 * @param urlPage 项目的相对路径
	 * @param articleId 用户选择的要查看的文章ID
	 * @param articleTypeId 用户选着的要产看的栏目ID
	 */
	public PraseImpl(String html,String path,int beginSize,String urlPage,int articleId,int articleTypeId){
		//--------------首先替换include标签 -----------
		this.html = RegexUtil.regexNull(html,new IncludePrase(html, path));
		this.beginSize = beginSize;
		this.urlPage = urlPage;
		this.articleId = articleId;
		this.articleTypeId = articleTypeId;
	}
//	
//	/**
//	 * 替换信息
//	 */
//	public String replace(){
//		//限制方法中For循环的次数，防止出现死循环
//		int confine = 1;
//		//----------------------------替换网站信息----------------------------
//		IWebBiz webBiz = new WebBizImpl();
//		
//		//从数据库取出网站信息
//		WebEntity web = webBiz.queryWebInfo(1);
//		
//		//释放内存
//		webBiz = null;
//		
//		
//		//替换网站版权信息标签：{ms: global.copyright/}
//		regex = new GlobolCopyrightPrase(html,web.getWebCopyright());
//		
//		//替换网站关键字标签:{ms: global.keyword/}
//		regex = new GlobolKeywordPrase(regex.parse(),web.getWebKeyword());
//		
//		//替换网站LOGO标签：{ms: global.logo/}
//		regex = new GlobolLogoPrase(regex.parse(),web.getWebLogo());
//		
//		//替换网站名称标签：{ms:global.name /}
//		regex = new GlobolNamePrase(regex.parse(),web.getWebTitle());
//		
//		//替换模版链接地址标签：{ms: globalskin.url /}
//		String globalskinUrl = web.getWebRealmName()+JspPage.PATH_SYMBOL+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+web.getWebStyle();
//		regex = new GlobolSkinUrlPrase(regex.parse(),globalskinUrl);
//		
//		//替换网站链接地址标签:{ms:global.url/}
//		regex = new GlobolUrlPrase(regex.parse(),web.getWebRealmName());
//		
//		//替换网站描述标签:{ms: global.descrip/}
//		regex = new GlobolDescripPrase(regex.parse(),web.getWebDescrip());
//		
//		//释放内存
//		web = null;
//		
//		String webHtml = regex.parse();
//		
//		//----------------------------替换列表标签----------------------------
//		//需要替换的列表文章内容的Biz
//		IArticleBiz articleBiz = new ArticleBizImpl();
//		
//		//查找当前模版页面拥有多少个列表标签
//		int listNum = ListPrase.listNum(webHtml);
//		//替换完分页标签后的HTML代码
//		String pageHtml = webHtml;
//		
//		for(int i = 0;i<listNum;i++){
//			confine++;
//			if(StringUtil.constraintFor(listNum,confine)){
//				break;
//			}
//			//当前列表标签中属性的集合-------------------
//			Map<String,String> mapProperty = ListPrase.listProperty(pageHtml);
//			
//			//取当前标签下的栏目ID
//			int articleTypeIdHtml = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_TYPEID));
//			
//			if(articleTypeIdHtml == 0 && articleTypeId != 0){
//				articleTypeIdHtml = articleTypeId;
//			}
//			//取出当前栏目下的子栏目Id
//			IArticleTypeBiz artcileType = new ArticleTypeBizImpl();
//			List<Integer> listArticleTypeId = artcileType.searchTreeSonId(articleTypeIdHtml);
//			
//			//列表每页显示的数量
//			int size = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_SIZE));
//			//显示文章的形式flag属性
//			int flag = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_FLAG)); 
//			
//			//显示文章的形式noflag属性
//			int noFlag = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_NOFLAG));
//			
//			//数据库中该栏目下文章的总数
//			int articTotal = articleBiz.queryArtcTotal(articleTypeIdHtml, flag, noFlag);
//			
//			//释放内存
//			mapProperty = null;
//			
//			if(size == 0 || size<0 || size > articTotal){
//				size = articTotal;
//			}
//			IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
//			
//			//当数据库中该栏目下没有该文章时不取数据
//			if(articTotal != 0){
//				//从数据库取出文章列表数组
//				List<ArticleEntity> listArticles = articleBiz.queryListPrase(listArticleTypeId,flag,noFlag,beginSize,size);
//				
//				//取出当前文章的分类
//				String articleType = "";
//				if(articleTypeIdHtml != 0){
//					ArticleTypeEntity articleTypeEntity = articleTypeBiz.articleTypeSearchWithId(articleTypeIdHtml);
//					if(articleTypeEntity != null){
//						articleType = articleTypeEntity.getArticleTypeName();
//					}
//				}
//				//替换列表标签
//				regex = new ListPrase(pageHtml,listArticles,articleType,urlPage);
//			}else{
//				regex = new ListPrase(pageHtml,null,null,urlPage);
//			}
//			
//			//释放内存
//			articleTypeBiz = null;
//			
//			String listHtml = regex.parse();
//			
//		//----------------------------替换分页标签----------------------------
//			String urlArticleType = urlPage;
//			if(articleTypeId != 0){
//				urlArticleType = urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId;
//			}
//			//替换分页标签
//			regex = new PagePrase(listHtml,urlArticleType,articTotal,size,beginSize);
//			
//			//替换页面的总数，当前文章处于第几页，列表文章的总数标签
//			regex = new PageNumPrase(regex.parse(), size, beginSize,articTotal);
//			
//			pageHtml = regex.parse();
//		}
//		//----------------------------解析文章标签----------------------------
//		
//		IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
//		
//		//替换完文章标签后的HTML模版
//		String articleHtml = pageHtml;
//		//判断HTML代码中属否存在文章标签
//		//判断用户是否查看文章，如果查看则开始解析文章标签
//		if(articleId != 0 ){
//			//储存从数据库中取出的文章信息
//			ArticleEntity article = new ArticleEntity();
//			
//			article.setArticleId(articleId);
//			//根据提交的文章ID，从数据库中取出文章信息
//			article = articleBiz.selectEntity(article);
//			if(article != null){
//				
//				//替换文章作者标签：{ms:field.author/}
//				regex = new ArticleAuthorPrase(pageHtml,article.getArticleAuthor());
//				
//				//替换文章内容标签：{ms:field.author/}
//				regex = new ArticleContentPrase(regex.parse(),article.getArticleContent());
//				
//				//替换文章时间标签：{ms:field.date  fmt="yyyy-mm-dd"/}
//				regex = new ArticleDatePrase(regex.parse(),article.getArticleDate());
//				
//				//替换文章发布来源标签：{ms:field.source/}
//				regex = new ArticleSourcePrase(regex.parse(),article.getArticleSource());
//				
//				//替换文章标题标签： {ms:field.title/}
//				regex = new ArticleTitlePrase(regex.parse(), article.getArticleTitle());
//				
//				//取出当前文章的栏目ID
//				int articleTypeId = article.getArticleType();
//				
//				//替换文章栏目链接标签{ms:filed.typelink/}
//				regex = new ArticleTypeLinkPrase(regex.parse(),urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId);
//	
//				//根据ID查找出当前文章的栏目名称
//				String articleTypeTitle = articleTypeBiz.articleTypeSearchWithId(articleTypeId).getArticleTypeName();
//				
//				//替换文章所在栏目标签：{ms:field.typetitle/}
//				regex = new ArticleTypeTitlePrase(regex.parse(), articleTypeTitle);
//				
//				//替换当前文章内容链接标签：{ms:field.link}
//				String link = urlPage+RegexConstant.HTML_TAG+CreateHtmlFile.pathArticlTypeBulid(article.getArticleType())+articleId+"."+RegexConstant.HTML_TAG;
//				regex = new ArticleLinkPrase(regex.parse(), link);
//				
//				
//				//替换上一篇文章、下一篇文章，链接、标题，标签
//				Map<String,ArticleEntity> mapArticle = articleBiz.queryArticleMap(articleTypeId, articleId);
//				
//				//释放内存
//				articleBiz = null;
//				
//				regex = new ArticleHistoryPrase(regex.parse(), mapArticle, urlPage);
//				
//				articleHtml = regex.parse();
//			}
//		}
//		
//		//当只存在栏目ID时，解析相关的文章中的栏目标签
//		if(articleTypeId != 0){
//			String articleTypeTitle = articleTypeBiz.articleTypeSearchWithId(articleTypeId).getArticleTypeName();
//			//替换文章所在栏目标签：{ms:field.typetitle/}
//			regex = new ArticleTypeTitlePrase(regex.parse(),articleTypeTitle);
//			
//			//替换文章栏目链接标签{ms:filed.typelink/}
//			regex = new ArticleTypeLinkPrase(regex.parse(),urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId);
//			articleHtml = regex.parse();
//		}	
//		//----------------------------解析栏目标签----------------------------
//		
//		//替换完列表标签后的TML文件
//		String channel = articleHtml;
//		
//		//查找当前模版页面拥有多少个栏目列表标签
//		int strNumType = ChannelPrase.channelNum(channel);
//		
//		//重置限制值
//		confine = 1;
//		for(int i = 0;i<strNumType;i++){
//			confine++;
//			if(StringUtil.constraintFor(strNumType,confine)){
//				break;
//			};
//			//当前列表栏目中属性的集合
//			Map<String,String> mapProperty = ChannelPrase.channelProperty(channel);
//			
//			//取当前标签下的栏目ID
//			int articleTypeIdHtml = StringUtil.StrInt(mapProperty.get(RegexConstant.CHANNEL_TYPEID));
//			
//			if(articleTypeIdHtml == 0 && articleTypeId != 0){
//				articleTypeIdHtml = articleTypeId;
//			}
//			
//			if(articleTypeIdHtml != 0){
//				//取出栏目的取值范围
//				String type = mapProperty.get(RegexConstant.CHANNEL_TYPE);
//				
//				//根据范围在BIZ中取出不同的栏目信息
//				List<ArticleTypeEntity> articleTypeList = null;
//				
//				//判断用户填写的栏目属性，如果未填写那么取当前栏目的下级栏目，如果但钱栏目没有下级栏目那么晚取本级栏目
//				//如果填写:son,那么取下级栏目，没有下级栏目则取本级栏目
//				//如果为：top,那么取上级栏目，如果没有上级栏目则取本机栏目
//				//如果为：level,则取本级栏目
//				if(type == null){
//					articleTypeList = articleTypeBiz.searchTreeSon(articleTypeIdHtml);
//				}else if(type.equals(RegexConstant.CHANNEL_TYPE_SON)){
//					articleTypeList = articleTypeBiz.searchTreeSon(articleTypeIdHtml);
//				}else if(type.equals(RegexConstant.CHANNEL_TYPE_TOP)){
//					articleTypeList = articleTypeBiz.searchTreeTop(articleTypeIdHtml);
//				}else if(type.equals(RegexConstant.CHANNEL_TYPE_LEVEL)){
//					articleTypeList = articleTypeBiz.articleTypeSearch(articleTypeIdHtml);
//				}
//				
//				if(articleTypeList == null || articleTypeList.size() == 0){
//					articleTypeList = articleTypeBiz.articleTypeSearch(articleTypeIdHtml);
//				}
//				
//				//释放内存
//				mapProperty = null;
//				
//				//替换栏目标签
//				regex = new ChannelPrase(channel,articleTypeList,urlPage);
//				//替换完栏目标签后的HTML代码
//				channel = regex.parse();
//			}
//		}
//		
//	//----------------解析封面标签-----------------
//		//替换完封面标签后的TML文件
//		String channelContHtml = channel;
//		//查找当前模版页面拥有多少个封面列表标签
//		int channelConNum = ChannelContPrase.channelContNum(channelContHtml);
//		
//		//重置限制值
//		confine = 1;
//		for(int i=0;i<channelConNum;i++){
//			confine++;
//			if(StringUtil.constraintFor(channelConNum, confine)){
//				break;
//			};
//			//取出当前封面标签中的封面ID
//			int channelTypeId = ChannelContPrase.channelContTypeId(channelContHtml);
//			if(channelTypeId == 0 && articleTypeId != 0){
//				channelTypeId = articleTypeId;
//			}
//			String channelCont = "";
//			//取出当前封面的内容
//			if(channelTypeId!=0){
//				IArticleTypeBiz artcileType = new ArticleTypeBizImpl();
//				ArticleTypeEntity articleType = artcileType.articleTypeSearchWithId(channelTypeId);
//				if(articleType != null){
//					channelCont = articleType.getArticleTypeContent();
//				}
//			}
//			
//			//释放内存
//			articleTypeBiz = null;
//			
//			//替换封面标签
//			regex = new ChannelContPrase(channelContHtml,channelCont);
//			channelContHtml = regex.parse();
//		}
//		
//		
//		return channelContHtml;
//	}
//	
//}


/**
 * 替换信息
 */
public String replace(){
	//限制方法中For循环的次数，防止出现死循环
	int confine = 1;
	//----------------------------替换网站信息----------------------------
	IWebBiz webBiz = new WebBizImpl();
	
	//从数据库取出网站信息
	WebEntity web = webBiz.queryWebInfo(1);
	
	//释放内存
	webBiz = null;
	
	html = RegexUtil.regexNull(html, new GlobolCopyrightPrase(html,web.getWebCopyright()));
	
	//替换网站版权信息标签：{ms: global.copyright/}
	html = RegexUtil.regexNull(html,new GlobolCopyrightPrase(html,web.getWebCopyright()));
	
	//替换网站关键字标签:{ms: global.keyword/}
	html = RegexUtil.regexNull(html,new GlobolKeywordPrase(html,web.getWebKeyword()));
	
	//替换网站LOGO标签：{ms: global.logo/}
	html = RegexUtil.regexNull(html,new GlobolLogoPrase(html,web.getWebLogo()));
	
	//替换网站名称标签：{ms:global.name /}
	html = RegexUtil.regexNull(html,new GlobolNamePrase(html,web.getWebTitle()));
	
	//替换模版链接地址标签：{ms: globalskin.url /}
	String globalskinUrl = web.getWebRealmName()+JspPage.PATH_SYMBOL+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+web.getWebStyle();
	html = RegexUtil.regexNull(html,new GlobolSkinUrlPrase(html,globalskinUrl));
	
	//替换网站链接地址标签:{ms:global.url/}
	html = RegexUtil.regexNull(html,new GlobolUrlPrase(html,web.getWebRealmName()));
	
	//替换网站描述标签:{ms: global.descrip/}
	html = RegexUtil.regexNull(html,new GlobolDescripPrase(html,web.getWebDescrip()));
	
	//释放内存
	web = null;
	
	String webHtml = html;
	
	//----------------------------替换列表标签----------------------------
	//需要替换的列表文章内容的Biz
	IArticleBiz articleBiz = new ArticleBizImpl();
	
	//查找当前模版页面拥有多少个列表标签
	int listNum = ListPrase.listNum(webHtml);
	//替换完分页标签后的HTML代码
	String pageHtml = webHtml;
	
	for(int i = 0;i<listNum;i++){
		confine++;
		if(StringUtil.constraintFor(listNum,confine)){
			break;
		}
		//当前列表标签中属性的集合-------------------
		Map<String,String> mapProperty = ListPrase.listProperty(pageHtml);
		
		//取当前标签下的栏目ID
		int articleTypeIdHtml = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_TYPEID));
		
		if(articleTypeIdHtml == 0 && articleTypeId != 0){
			articleTypeIdHtml = articleTypeId;
		}
		//取出当前栏目下的子栏目Id
		IArticleTypeBiz artcileType = new ArticleTypeBizImpl();
		List<Integer> listArticleTypeId = artcileType.searchTreeSonId(articleTypeIdHtml);
		
		//列表每页显示的数量
		int size = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_SIZE));
		//显示文章的形式flag属性
		int flag = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_FLAG)); 
		
		//显示文章的形式noflag属性
		int noFlag = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_NOFLAG));
		
		//数据库中该栏目下文章的总数
		int articTotal = articleBiz.queryArtcTotal(articleTypeIdHtml, flag, noFlag);
		
		//释放内存
		mapProperty = null;
		
		if(size == 0 || size<0 || size > articTotal){
			size = articTotal;
		}
		IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
		
		//当数据库中该栏目下没有该文章时不取数据
		if(articTotal != 0){
			//从数据库取出文章列表数组
			List<ArticleEntity> listArticles = articleBiz.queryListPrase(listArticleTypeId,flag,noFlag,beginSize,size);
			
			//释放内存
			listArticleTypeId = null;
			
			//取出当前文章的分类
			String articleType = "";
			if(articleTypeIdHtml != 0){
				ArticleTypeEntity articleTypeEntity = articleTypeBiz.articleTypeSearchWithId(articleTypeIdHtml);
				if(articleTypeEntity != null){
					articleType = articleTypeEntity.getArticleTypeName();
				}
			}
			//替换列表标签
			html = RegexUtil.regexNull(html,new ListPrase(pageHtml,listArticles,articleType,urlPage));
			//释放内存
			listArticles = null;
		}else{
			html = RegexUtil.regexNull(html,new ListPrase(pageHtml,null,null,urlPage));
		}
		
		//释放内存
		articleTypeBiz = null;
		
		String listHtml = html;
		
	//----------------------------替换分页标签----------------------------
		String urlArticleType = urlPage;
		if(articleTypeId != 0){
			urlArticleType = urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId;
		}
		//替换分页标签
		html = RegexUtil.regexNull(html,new PagePrase(listHtml,urlArticleType,articTotal,size,beginSize));
		
		//替换页面的总数，当前文章处于第几页，列表文章的总数标签
		html = RegexUtil.regexNull(html,new PageNumPrase(html, size, beginSize,articTotal));
		
		pageHtml = html;
	}
	//----------------------------解析文章标签----------------------------
	
	IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
	
	//替换完文章标签后的HTML模版
	String articleHtml = pageHtml;
	//判断HTML代码中属否存在文章标签
	//判断用户是否查看文章，如果查看则开始解析文章标签
	if(articleId != 0 ){
		//储存从数据库中取出的文章信息
		ArticleEntity article = new ArticleEntity();
		
		article.setArticleId(articleId);
		//根据提交的文章ID，从数据库中取出文章信息
		article = articleBiz.selectEntity(article);
		if(article != null){
			
			//替换文章作者标签：{ms:field.author/}
			html = RegexUtil.regexNull(html,new ArticleAuthorPrase(pageHtml,article.getArticleAuthor()));
			
			//替换文章内容标签：{ms:field.author/}
			html = RegexUtil.regexNull(html,new ArticleContentPrase(html,article.getArticleContent()));
			
			//替换文章时间标签：{ms:field.date  fmt="yyyy-mm-dd"/}
			html = RegexUtil.regexNull(html,new ArticleDatePrase(html,article.getArticleDate()));
			
			//替换文章发布来源标签：{ms:field.source/}
			html = RegexUtil.regexNull(html,new ArticleSourcePrase(html,article.getArticleSource()));
			
			//替换文章标题标签： {ms:field.title/}
			html = RegexUtil.regexNull(html,new ArticleTitlePrase(html, article.getArticleTitle()));
			
			//取出当前文章的栏目ID
			int articleTypeId = article.getArticleType();
			
			//替换文章栏目链接标签{ms:filed.typelink/}
			html = RegexUtil.regexNull(html,new ArticleTypeLinkPrase(html,urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId));

			//根据ID查找出当前文章的栏目名称
			String articleTypeTitle = articleTypeBiz.articleTypeSearchWithId(articleTypeId).getArticleTypeName();
			
			//替换文章所在栏目标签：{ms:field.typetitle/}
			html = RegexUtil.regexNull(html,new ArticleTypeTitlePrase(html, articleTypeTitle));
			
			//替换当前文章内容链接标签：{ms:field.link}
			String link = urlPage+RegexConstant.HTML_TAG+CreateHtmlFile.pathArticlTypeBulid(article.getArticleType())+articleId+"."+RegexConstant.HTML_TAG;
			html = RegexUtil.regexNull(html,new ArticleLinkPrase(html, link));
			
			
			//替换上一篇文章、下一篇文章，链接、标题，标签
			Map<String,ArticleEntity> mapArticle = articleBiz.queryArticleMap(articleTypeId, articleId);
			
			//释放内存
			articleBiz = null;
			
			html = RegexUtil.regexNull(html,new ArticleHistoryPrase(html, mapArticle, urlPage));
			
			articleHtml = html;
		}
	}
	
	//当只存在栏目ID时，解析相关的文章中的栏目标签
	if(articleTypeId != 0){
		String articleTypeTitle = articleTypeBiz.articleTypeSearchWithId(articleTypeId).getArticleTypeName();
		//替换文章所在栏目标签：{ms:field.typetitle/}
		html = RegexUtil.regexNull(html,new ArticleTypeTitlePrase(html,articleTypeTitle));
		
		//替换文章栏目链接标签{ms:filed.typelink/}
		html = RegexUtil.regexNull(html,new ArticleTypeLinkPrase(html,urlPage+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleTypeId));
		articleHtml = html;
	}	
	//----------------------------解析栏目标签----------------------------
	
	//替换完列表标签后的TML文件
	String channel = articleHtml;
	
	//查找当前模版页面拥有多少个栏目列表标签
	int strNumType = ChannelPrase.channelNum(channel);
	
	//重置限制值
	confine = 1;
	for(int i = 0;i<strNumType;i++){
		confine++;
		if(StringUtil.constraintFor(strNumType,confine)){
			break;
		};
		//当前列表栏目中属性的集合
		Map<String,String> mapProperty = ChannelPrase.channelProperty(channel);
		
		//取当前标签下的栏目ID
		int articleTypeIdHtml = StringUtil.StrInt(mapProperty.get(RegexConstant.CHANNEL_TYPEID));
		
		if(articleTypeIdHtml == 0 && articleTypeId != 0){
			articleTypeIdHtml = articleTypeId;
		}
		
		if(articleTypeIdHtml != 0){
			//取出栏目的取值范围
			String type = mapProperty.get(RegexConstant.CHANNEL_TYPE);
			
			//根据范围在BIZ中取出不同的栏目信息
			List<ArticleTypeEntity> articleTypeList = null;
			
			//判断用户填写的栏目属性，如果未填写那么取当前栏目的下级栏目，如果但钱栏目没有下级栏目那么晚取本级栏目
			//如果填写:son,那么取下级栏目，没有下级栏目则取本级栏目
			//如果为：top,那么取上级栏目，如果没有上级栏目则取本机栏目
			//如果为：level,则取本级栏目
			if(type == null){
				articleTypeList = articleTypeBiz.searchTreeSon(articleTypeIdHtml);
			}else if(type.equals(RegexConstant.CHANNEL_TYPE_SON)){
				articleTypeList = articleTypeBiz.searchTreeSon(articleTypeIdHtml);
			}else if(type.equals(RegexConstant.CHANNEL_TYPE_TOP)){
				articleTypeList = articleTypeBiz.searchTreeTop(articleTypeIdHtml);
			}else if(type.equals(RegexConstant.CHANNEL_TYPE_LEVEL)){
				articleTypeList = articleTypeBiz.articleTypeSearch(articleTypeIdHtml);
			}
			
			if(articleTypeList == null || articleTypeList.size() == 0){
				articleTypeList = articleTypeBiz.articleTypeSearch(articleTypeIdHtml);
			}
			
			//释放内存
			mapProperty = null;
			
			//替换栏目标签
			html = RegexUtil.regexNull(html,new ChannelPrase(channel,articleTypeList,urlPage));
			//替换完栏目标签后的HTML代码
			channel = html;
		}
	}
	
//----------------解析封面标签-----------------
	//替换完封面标签后的TML文件
	String channelContHtml = channel;
	//查找当前模版页面拥有多少个封面列表标签
	int channelConNum = ChannelContPrase.channelContNum(channelContHtml);
	
	//重置限制值
	confine = 1;
	for(int i=0;i<channelConNum;i++){
		confine++;
		if(StringUtil.constraintFor(channelConNum, confine)){
			break;
		};
		//取出当前封面标签中的封面ID
		int channelTypeId = ChannelContPrase.channelContTypeId(channelContHtml);
		if(channelTypeId == 0 && articleTypeId != 0){
			channelTypeId = articleTypeId;
		}
		String channelCont = "";
		//取出当前封面的内容
		if(channelTypeId!=0){
			IArticleTypeBiz artcileType = new ArticleTypeBizImpl();
			ArticleTypeEntity articleType = artcileType.articleTypeSearchWithId(channelTypeId);
			if(articleType != null){
				channelCont = articleType.getArticleTypeContent();
			}
		}
		
		//释放内存
		articleTypeBiz = null;
		
		//替换封面标签
		html = RegexUtil.regexNull(html,new ChannelContPrase(channelContHtml,channelCont));
		channelContHtml = html;
	}
	
	
	return channelContHtml;
}

}
