package com.mingsoft.regex.impl;

import com.mingsoft.biz.IWebBiz;
import com.mingsoft.biz.impl.WebBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.io.IoReader;
import com.mingsoft.regex.IPrase;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.util.StringUtil;

/**
 * 读取和解析HTML代码中的标签
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class RegexHtmlImpl implements IRegexHtml{
	/**
	 * 网站的基本信息
	 */
	private IWebBiz webBiz = new WebBizImpl();
	
	/**
	 * HTML模版所在的物理路径（包括模版所在的文件夹名）
	 */
	private String projectUrl;
	
	/**
	 * 用IO流读出的原模版文件
	 */
	private String htmlTemplate;
	
	/**
	 * 实现分页功能时定位页面所在的位置
	 */
	private int beginSize;
	
	/**
	 * 项目的相对路径
	 */
	private String urlPage;
	
	/**
	 * 获取用户需要查看的文章ID
	 */
	private int articleId = 0; 
	
	/**
	 * IO流要读取的HTML模版的名称
	 */
	public String htmlViewName;
	
	/**
	 * 获取用户需要查看的栏目ID
	 */
	private int articleTypeId = 0;
	/**
	 * 构造读取模版和替换标签必须的参数
	 * @param projectUrl 项目的物理路径
	 * @param htmlViewName IO流要读取的HTML模版的名称
	 * @param beginSize 实现分页功能时定位页面所在的位置
	 * @param urlPage 项目的相对路径
	 * @param articleId 获取用户需要查看的文章ID，默认为0时不存在
	 * @param articleTypeId  获取用户需要查看的栏目ID，默认为0时不存在
	 */
	public RegexHtmlImpl(String projectUrl,String htmlViewName,int beginSize,String urlPage,int articleId,int articleTypeId){
		//获取模版文件夹名称
		WebEntity web = webBiz.queryWebInfo(1);
		String tempLate = web.getWebStyle();
		this.projectUrl = projectUrl+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+tempLate;
		this.htmlViewName = htmlViewName;
		this.beginSize = beginSize;
		this.urlPage = urlPage;
		this.articleId = articleId;
		this.articleTypeId = articleTypeId;
	}
	
	/**
	 * 读取原HTML代码
	 */
	public String getHtmlTemplate() {
		// TODO Auto-generated method stub
		this.htmlTemplate = reafHtml(projectUrl,htmlViewName);
		if(!StringUtil.strNull(this.htmlTemplate)){
			regexHtml();
		}else{
			//提示错误：未找到模版
			this.htmlTemplate = projectUrl+JspPage.PATH_SYMBOL+htmlViewName + "("+RegexConstant.VIEW_NOT_HTML+")";
		}
		return this.htmlTemplate;
	}

	/**
	 * 替换HTML上的标签
	 * @param beginSize
	 * @param urlPage
	 * @param articleId
	 * @param articleTypeId
	 */
	private void regexHtml(){
		//解析HTML上的标签
		IPrase prase = new PraseImpl(htmlTemplate,projectUrl,beginSize,urlPage,articleId,articleTypeId);
		this.htmlTemplate = prase.replace();
		//释放内存
		prase = null;
	}
	
	/**
	 * 读取HTML模版
	 * @param projectUrl项目的物理路径
	 * @param htmlViewName HTML模版的名称
	 * @return 读取成功后的模版
	 */
	private String reafHtml(String projectUrl,String htmlViewName){
		//IO流读取模版
		String htmlComent = IoReader.readFile(projectUrl+JspPage.PATH_SYMBOL+htmlViewName);
		
		return htmlComent;
	}
}
