package com.mingsoft.regex.prase;

import java.util.Map;

import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;
/**
 * 当前文章的上一篇文章，下一篇文章的链接标题解析（单标签）
 * 上一篇文章链接：{ms:field.prelink/}
 * 上一篇文章标题：{ms:field.pretitle/}
 * 下一篇文章链接：{ms:field.nextlink/}
 * 下一篇文章标题：{ms:field.nexttitle/}
 * 文章内容标签
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleHistoryPrase extends Regex {
	
	/**
	 * 替换当前标签的内容
	 */
	private Map<String,ArticleEntity> mapArticle = null;
	
	/**
	 * 原HTML代码的相对路径
	 */
	private  String urlPage;
	
	/**
	 * 构造必须的参数
	 * @param htmlContent 原HTML代码
	 * @param newContent 标签内容
	 * @param urlPage 当前项目的相对地址
	 */
	public ArticleHistoryPrase(String htmlContent,Map<String,ArticleEntity> newContent,String urlPage){
		super.htmlCotent = htmlContent;
		this.mapArticle = newContent;
		this.urlPage = urlPage;
	}
	
	@Override
	public String parse() {
		// TODO Auto-generated method stub
		//替换上一篇文章链接
		int articleId = mapArticle.get(RegexConstant.ARTICLE_PRE).getArticleId();
		super.htmlCotent = replaceRegex(urlLink(articleId),RegexEnum.ARTICLE_PRELINK_FIELD);
		//替换上一篇文章标题
		super.htmlCotent = replaceRegex(mapArticle.get(RegexConstant.ARTICLE_PRE).getArticleTitle(),RegexEnum.ARTICLE_PRETITLE_FIELD);
		//替换下一篇文章链接
		articleId = mapArticle.get(RegexConstant.ARTICLE_NEXT).getArticleId();
		super.htmlCotent = replaceRegex(urlLink(articleId),RegexEnum.ARTICLE_NEXTLINK_FIELD);
		//替换下一篇文章标题
		super.htmlCotent = replaceRegex(mapArticle.get(RegexConstant.ARTICLE_NEXT).getArticleTitle(),RegexEnum.ARTICLE_NEXTTITLE_FIELD);
		return super.htmlCotent;
	}
	
	/**
	 * 替换不同的标签
	 * @param htmlContent HTML代码
	 * @param newContent 替换内容
	 * @param regex 正则表达式
	 * @return 替换完成后的HTML代码
	 */
	private String replaceRegex(String newContent,RegexEnum regex){
		//判断用户是否在HTML代码中写入了该标签
			super.newCotent = newContent;
			String overHtml = super.replaceAll(regex);
		return overHtml;
	}
	
	private String urlLink(int articleId){
		String urlLink =  urlPage+RegexConstant.HTML_TAG+CreateHtmlFile.pathBulid(articleId,0)+articleId+"."+RegexConstant.HTML_TAG;
		return urlLink;
	}
}
