package com.mingsoft.regex.prase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;
import com.mingsoft.util.RegexUtil;
import com.mingsoft.util.StringUtil;
/**
 * 栏目标签 (列表标签)
 * {ms:channel type=”sun” typeid=””}：栏目父标标签
 * {/ms:channel}:栏目父标签
 * [field.typeindex/]：栏目序号标签
 * [field.typetitle/]：栏目名称标签
 * [field.typelink/]：栏目链接标签
 * [field.typekeyword/]：栏目关键字
 * [field.typedescrip/]：栏目描述
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ChannelPrase extends Regex {
	/**
	 * 构造替换栏目标签的必须参数
	 * @param htmlCotent HTML模版
	 * @param newContent 替换内容
	 */
	public ChannelPrase(String htmlCotent,List<ArticleTypeEntity> newContent,String page){
		//在HTML模版中标记出要用内容替换的标签
		String htmlCotents = channelPrplace(htmlCotent,RegexEnum.TAB_BEGIN_LIST,RegexEnum.CHANNEL_BEGIN);
		htmlCotents = channelPrplace(htmlCotents,RegexEnum.TAB_END_LIST,RegexEnum.CHANNEL_END);
		//经过遍历后的数组标签
		super.newCotent = articleTypeList(htmlCotents,newContent,page);
		super.htmlCotent = htmlCotents;
	}
	
	@Override
	public String parse() {
		// TODO Auto-generated method stub
		String channelHtml = super.replaceFirst(RegexEnum.TAB_LIST);
		return channelHtml;
	}
	
	/**
	 * 将用需要用内容替换的标签换成标记标签
	 * @param htmlCotent 原HTML文件
	 * @return 替换好标签后的HTNL文件
	 */
	private String channelPrplace(String htmlCotent,RegexEnum regexTab,RegexEnum regex){
		String htmlCotents = "";
		super.htmlCotent = htmlCotent;
		super.newCotent = regexTab.getRegex();
		htmlCotents = super.replaceFirst(regex);
		if(htmlCotents.equals("")){
			htmlCotents = "标签格式错误";
		}
		return htmlCotents;
	}
	
	/**
	 * 替换的数组内容
	 * @param htmlCotent 用标记标签替换好的HTML模版代码
	 * @param newContent 需要插入数组的内容
	 * @return 如果存在该标签返回替换后的标签和内容，如果不存在则返回空
	 */
	private String tabContent(String htmlCotent,String newContent,RegexEnum regex){
		if(StringUtil.strNull(newCotent)){
			newCotent = regex.getRegex();
		}
		String htmlCotents = htmlCotent;
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(htmlCotent);
		if(matcher.find()){
			htmlCotents = matcher.replaceAll(newContent);
		}
		return htmlCotents;
	}
	
	/**
	 * 在替换好标签的HTML代码中将用标签替换的那段HTML代码截取出来
	 * @param htmlCotent 替换好标签后的HTML代码
	 * @return 标签替换的那段HTML代码截取出来
	 */
	private String tabHtml(String htmlCotent){
		Pattern patternList = Pattern.compile(RegexEnum.TAB_LIST.getRegex());
		Matcher matcherList = patternList.matcher(htmlCotent);
		if(matcherList.find()){
			htmlCotent = matcherList.group(1);
		}
		return htmlCotent;
	}
	
	/**
	 * 遍历文章数组，将取出的内容替换标签
	 * [field.typeindex/]：栏目序号标签
	 * [field.typetitle/]：栏目名称标签
	 * [field.typelink/]：栏目链接标签
	 * @param htmlCotent 原HTML代码
	 * @param articleList 文章数组
	 * @return 用内容替换标签后的HTML代码
	 */
	private String articleTypeList(String htmlCotent,List<ArticleTypeEntity> articleTypeList,String page){
		String tabHtml = tabHtml(htmlCotent);
		String htmlList = "";
		if(articleTypeList!=null && articleTypeList.size() != 0){
			for(int i = 0;i<articleTypeList.size();i++){
				ArticleTypeEntity articleType = articleTypeList.get(i);
				//替换栏目序号标签
				htmlList += tabContent(tabHtml,StringUtil.intSrt((i+1)),RegexEnum.CHANNEL_INDEX);
				//替换栏目标题标签
				htmlList = tabContent(htmlList,articleType.getArticleTypeName(),RegexEnum.CHANNEL_TITLE);
				//替换栏目链接标签
				String linkUrl = page+RegexConstant.REGEX_ARTICLE_TYPE_URL+articleType.getArticleTypeId();
				if(articleType.getArticleTypeQuality()==2){
					linkUrl = page+ RegexConstant.HTML_TAG+CreateHtmlFile.pathBulid(0,articleType.getArticleTypeId())+articleType.getArticleTypeId()+"." + RegexConstant.HTML_TAG;
				}
				htmlList = tabContent(htmlList,linkUrl,RegexEnum.CHANNEL_LINK);
				//替换栏目关键字标签
				htmlList = tabContent(htmlList,articleType.getArticleTypeKeyword(),RegexEnum.CHANNEL_KEYWORD);
				//替换栏目描述标签
				htmlList = tabContent(htmlList,articleType.getArticleTypeDescrip(),RegexEnum.CHANNEL_DESCRIP);
				
			}
		}else{
			htmlList = RegexConstant.REGEX_CHANNEL_ERRO;
		}
		return htmlList;
	}
	
//——————————————————————————————————解析父标签中的属性开始——————————————————————————————————
	/**
	 *获取模版文件中栏目列表的个数 
	 * @param html 文件模版
	 * @return 返回该字符串的个数
	 */
	public static int channelNum(String html){
		int channelNumBegin = RegexUtil.regexNum(html, RegexEnum.CHANNEL_BEGIN);
		return channelNumBegin;
	}
	
	/**
	 * 取出栏目标签中的属性
	 * @param html HTML模版
	 * @return 属性集合
	 */
	public static Map<String,String> channelProperty(String html){
		 Map<String,String> listPropertyMap = new HashMap<String, String>();
		 String listProperty = RegexUtil.nature(html, RegexEnum.CHANNEL_PROPERTY,1);
		 List<String> listPropertyName = RegexUtil.natureAll(listProperty, RegexEnum.PRORETY_NAME, 1);
		 List<String> listPropertyValue = RegexUtil.natureAll(listProperty, RegexEnum.PROPERTY_VALUE, 1);
		 for(int i = 0 ;i<listPropertyName.size();i++){
			 listPropertyMap.put(listPropertyName.get(i).toString(), listPropertyValue.get(i).toString());
		 }
		 return listPropertyMap;
	}
//——————————————————————————————————解析父标签中的属性结束——————————————————————————————————	
}
