package com.mingsoft.regex.prase;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;
import com.mingsoft.util.RegexUtil;
import com.mingsoft.util.StringUtil;
/**
 * 解析列表标签,
 * {ms:arclist typeid= size= titlelen= flag = }:列表头标签,
 * {/ms:arclist}:列表尾标签,
 * 列表中的属性：
 * 			typeid 类型 int栏目ID,在列表模板和档案模板中一般不需要指定，在首页模板中允许用","分开表示多个栏目,
 * 			size 类型 int 返回文档列表总数,默认为20条全部返回，也可以配合分页使用,
 * 			titlelen 类型 int 标题长度,等同于titlelength。默认40个汉字,
 * 			flag 类型 String flag = 'c' 自定义属性值：推荐[c]幻灯[f],
 * [field.index/]:序号,根据显示条数显示的序号1 2 …..10,
 * [field.id/]:编号,对应文章在数据库里的自动编号,
 * [field.title/]:标题,标题长度根据titlelen的属性值指定，默认40个汉字,
 * [field.fulltitle/]:全部标题,显示完整的标题,
 * [field.author/]:作者,
 * [field.source/]:来源,
 * [field.date  fmt=”yyyy-mm-dd”/]:时间(非必填),
 * [field.content length=/]:内容,length=:内容的长度,指定获取文章长度(非必填),
 * [field.typename/]:分类名称，文章所属分类的名称,
 * [field.typeid/]:分类编号,文章所属分类的编号,
 * [field.typelink/]:分类连接,点击连接连接到当前分类的列表,
 * [field.link/]:内容链接,点击显示文章具体的内容地址,
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ListPrase extends Regex{
	/**
	 * 构造替换标签的属性  
	 * @param htmlCotent HTML模版
	 * @param articleType 分类名称
	 * @param 项目路径
	 * @param newContent 替换标签的内容
	 * @param 替换标签的ID
	 */
	public ListPrase(String htmlCotent,List<ArticleEntity> newContent,String articleType,String path){
		//在HTML模版中标记出要用内容替换的标签
		String htmlCotents = listPrplace(htmlCotent,RegexEnum.TAB_BEGIN_LIST,RegexEnum.BEGIN_LIST);
		//判断是否存在尾标签存在正常解析，不存在将头标签换成替换标签让其直接替换
		htmlCotents = listPrplace(htmlCotents,RegexEnum.TAB_END_LIST,RegexEnum.END_LIST);
		//经过遍历后的数组标签
		super.newCotent = articleList(htmlCotents,newContent,articleType,htmlCotent,path);
		super.htmlCotent = htmlCotents;
	}    
	
	
	@Override
	public String parse() {
			String listHtml = super.replaceAll(RegexEnum.TAB_LIST);
			return listHtml;
	}
	
	/**
	 * 将用需要用内容替换的标签换成标记标签
	 * @param htmlCotent 原HTML文件
	 * @return 替换好标签后的HTNL文件
	 */
	private String listPrplace(String htmlCotent,RegexEnum regexTab,RegexEnum regex){
		String htmlCotents = "";
		super.htmlCotent = htmlCotent;
		super.newCotent = regexTab.getRegex();
		htmlCotents = super.replaceFirst(regex);
		if(htmlCotents.equals("")){
			htmlCotents = RegexConstant.REGEX_ERRO;
		}
		return htmlCotents;
	}
	
	/**
	 * 替换的数组内容
	 * @param htmlCotent 用标记标签替换好的HTML模版代码
	 * @param newContent 需要插入数组的内容
	 * @return 如果存在该标签返回替换后的标签和内容，如果不存在则返回空
	 */
	private String tabContent(String htmlCotent,String newContent,RegexEnum regex){
		if(StringUtil.strNull(newContent)){
			newCotent = RegexConstant.REGEX_ERRO;
		}
		String htmlCotents = htmlCotent;
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(htmlCotent);
		if(matcher.find()){
			htmlCotents = matcher.replaceAll(newContent);
		}
		return htmlCotents;
	}
	
	/**
	 * 在替换好标签的HTML代码中将用标签替换的那段HTML代码截取出来
	 * @param htmlCotent 替换好标签后的HTML代码
	 * @return 标签替换的那段HTML代码截取出来
	 */
	private String tabHtml(String htmlCotent){
		String tabHtml = "";
		Pattern patternList = Pattern.compile(RegexEnum.TAB_LIST.getRegex());
		Matcher matcherList = patternList.matcher(htmlCotent);
		if(matcherList.find()){
			tabHtml = matcherList.group(1);
		}
		return tabHtml;
	}
	
	/**
	 * 遍历文章数组，将取出的内容替换标签
	 * @param htmlCotent 原HTML代码
	 * @param articleList 文章数组
	 * @param 项目路径
	 *  @param size 每页显示信息的数量
	 * [field.typelink/]:分类连接,点击连接连接到当前分类的列表(???)
	 * @return 用内容替换标签后的HTML代码
	 */
	private String articleList(String htmlCotent,List<ArticleEntity> articleList,String articleType,String rewHtml,String path){
		String htmlList = "";
		String tabHtml = "";
		tabHtml = tabHtml(htmlCotent);
		if(articleList != null && tabHtml !=null && articleList.size()!=0 && tabHtml!=""){
			for(int i = 0;i<articleList.size();i++){
				ArticleEntity article = articleList.get(i);
				//序号,根据显示条数显示的序号1 2 …..10。
				htmlList += tabContent(tabHtml,StringUtil.intSrt((i+1)),RegexEnum.INDEX_FIELD_LIST);
				//编号,对应文章在数据库里的自动编号。
				htmlList = tabContent(htmlList,StringUtil.intSrt(article.getArticleId()),RegexEnum.ID_FIELD_LIST);
				//标题,标题长度根据titlelen的属性值指定，默认40个汉字,
				htmlList = tabContent(htmlList,titleLeng(article.getArticleTitle(),rewHtml),RegexEnum.TITLE_FIELD_LIST);
				//全部标题,显示完整的标题。
				htmlList = tabContent(htmlList,StringUtil.srtingNull(article.getArticleTitle()),RegexEnum.FULLTITLE_FIELD_LIST);
				//文章作者。
				htmlList = tabContent(htmlList,StringUtil.srtingNull(article.getArticleAuthor()),RegexEnum.AUTHOR_FIELD_LIST);
				//文章来源。
				htmlList = tabContent(htmlList,StringUtil.srtingNull(article.getArticleSource()),RegexEnum.SOURCE_FIELD_LIST);
				//文章发布时间(非必填),
				htmlList = tabContent(htmlList,date(article.getArticleDate(),htmlList),RegexEnum.DATE_FIELD_LIST);
				//文章内容,
				htmlList = tabContent(htmlList,contentLeng(article.getArticleContent(), htmlList),RegexEnum.CONTENT_FIELD_LIST);
				//分类名称，文章所属分类的名称,
				htmlList = tabContent(htmlList,StringUtil.srtingNull(articleType),RegexEnum.TYPENAME_FIELD_LIST);
				//文章链接 ：[field.link/]
				String Link = path+RegexConstant.HTML_TAG+CreateHtmlFile.pathArticlTypeBulid(article.getArticleType())+article.getArticleId()+"."+RegexConstant.HTML_TAG;
				htmlList = tabContent(htmlList,Link,RegexEnum.LINK_FIELD_LIST);
				//分类编号,文章所属分类的编号,
				htmlList = tabContent(htmlList,StringUtil.intSrt(article.getArticleType()),RegexEnum.TYPEID_FIELD_LIST);
				//文章略图[field.litpic/]
				htmlList = tabContent(htmlList,StringUtil.srtingNull(article.getArticleImg()),RegexEnum.LITPIC_FIELD_LIST);
				//当前页面文章的数量[field.num]
				String numArticle = Integer.toString(articleList.size());
				htmlList = tabContent(htmlList,numArticle,RegexEnum.NUM_ARTICLE_LIST);
			}
		}else{
				htmlList = RegexConstant.REGEX_ERRO;
		}
		return htmlList;
	}
	
	
	/**
	 * 判断列表父标签中标题的长度
	 * @param content 标题的内容
	 * @param htmlCotent HTML模版
	 * @return 截取后的文章标题
	 */
	private String titleLeng(String content,String htmlCotent){
		Map<String,String> mapProperty = ListPrase.listProperty(htmlCotent);
		//根据长度取出标题
		String contentNew = content;
		int length = StringUtil.StrInt(mapProperty.get(RegexConstant.LIST_TITLELENGTH));
		if(length != 0 && length < contentNew.length()){
				StringBuffer strBuff = new StringBuffer(contentNew);
				contentNew = strBuff.substring(0,length);
			}
		return contentNew;
	}
	
	/**
	 * 将时间格式转换成字符串型并改变时间的显示格式
	 * @param date 数据库中的时间
	 * @param htmlCotent 读取时间格式的HTML代码
	 * @return 时间
	 */
	private String date(Date date,String htmlCotent){
		//从HTML代码中取出时间的显示格式，默认为yyyy-MM-dd hh:mm:ss形式
		String typeDate = RegexConstant.REGEX_DATE;
		String fmt = RegexUtil.nature(htmlCotent, RegexEnum.DATE_FIELD_LIST, 2);
		if(!StringUtil.strNull(fmt)){
			typeDate = fmt;
		}
		//将时间转换成String型
		String srtDate = RegexConstant.REGEX_DATE_ERRO;
		if(date != null){
		try{	
			java.text.SimpleDateFormat forDate = new java.text.SimpleDateFormat(typeDate);
			srtDate = forDate.format(date);
		}catch (Exception e) {
			// TODO: handle exception
		}
		}
		return srtDate;
	}
	
	/**
	 * 判断列表标签中内容的长度
	 * @param content 标题的内容
	 * @param htmlCotent HTML模版
	 * @return 截取后的内容长度 v/
	 */
	private String contentLeng(String content,String htmlCotent){
		//从HTML代码中内容的长度，默认为全部显示
		int lengthCon = 0;
		String length = RegexUtil.nature(htmlCotent, RegexEnum.CONTENT_FIELD_LIST, 2);
			if(!StringUtil.strNull(length)){
				lengthCon = Integer.parseInt(length);
			}
		//根据长度取出内容
		String contentNew = content;
		if(lengthCon != 0 && !(lengthCon > contentNew.length())){
			StringBuffer strBuff = new StringBuffer(contentNew);
			contentNew = strBuff.substring(0,lengthCon);
		}
		return contentNew;
	}
	

	/**
	 *获取模版文件中文章列表的个数 
	 * @param html 文件模版
	 * @return 返回该字符串的个数
	 */
	public static int listNum(String html){
		int listNumBegin = RegexUtil.regexNum(html,RegexEnum.BEGIN_LIST);
		return listNumBegin;
	}
	
	/**
	 * 取出列表标签中的属性
	 * @param html HTML模版
	 * @return 属性集合
	 */
	public static Map<String,String> listProperty(String html){
		 Map<String,String> listPropertyMap = new HashMap<String, String>();
		 String listProperty = RegexUtil.nature(html, RegexEnum.LIST_PROPERTY,1);
		 List<String> listPropertyName = RegexUtil.natureAll(listProperty, RegexEnum.PRORETY_NAME, 1);
		 List<String> listPropertyValue = RegexUtil.natureAll(listProperty, RegexEnum.PROPERTY_VALUE, 1);
		 for(int i = 0 ;i<listPropertyName.size();i++){
			 listPropertyMap.put(listPropertyName.get(i).toString(), listPropertyValue.get(i).toString());
		 }
		 return listPropertyMap;
	}
	
}
