package com.mingsoft.regex.prase;

import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;
/**
 * 解析分页标签中的，页面总数，当前第几页，列表文章总数标签
 * 分页标签
 * 页面总数：{ms:page.total/}
 * 当前第几页：{ms:page.cur/}
 * 列表文章总数：{ms:page.articletotal/}
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class PageNumPrase extends Regex {
	
	/**
	 * 每页显示文章的数量
	 */
	private int size = 1;
	
	/**
	 * 当前处于第几页
	 */
	private int cur = 0;
	
	/**
	 * 列表中文章的总数
	 */
	private int articleTotal = 0;
	
	/**
	 * 构造替换标签必须的参数
	 * @param htmlContent 原HTML代码
	 * @param size 每页显示文章的数量
	 * @param cur 当前文章处于第几页
	 * @param articletotal 列表文章的总数
	 */
	public PageNumPrase(String htmlContent,int size,int cur,int articleTotal){
			super.htmlCotent = htmlContent;
			if(size == 0){
				size = 1;
			}
			this.size = size;
			this.cur = cur/size+1;
			this.articleTotal = articleTotal;
	}
	
	@Override
	public String parse() {
		// TODO Auto-generated method stub
		//替换页面总数标签
		int total = 1;
		int remainder = articleTotal%size;
		//计算页面数量
		if(articleTotal <= size){
			total = 1;
		}else{
			total = (articleTotal-remainder)/size +1;
		}
		super.newCotent = replaceRegex(RegexEnum.PAGE_TOTAL,total);
		//替换当前处于第几页标签
		super.newCotent = replaceRegex(RegexEnum.PAGE_CUR,cur);
		//替换当前列表下文章的总数
		super.newCotent = replaceRegex(RegexEnum.PAGE_ARTICLE_TOTAL,articleTotal);
		return super.newCotent;
	}
	
	public String replaceRegex(RegexEnum regex,int num){
		super.newCotent = Integer.toString(num);
		String html = super.replaceAll(regex);
		return html;
	}
}
