package com.mingsoft.regex.prase;

import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;

/**
 * 实现分页功能并进行标签的替换
 * 分页标签
 * 首页：{ms:page.index}
 * 上一页:{ms:page.pre/}
 * 下一页:{ms:page.next/}
 * 尾页:{ms:page.over/}
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class PagePrase extends Regex{
	/**
	 * 需要显示数据的总数量
	 */
	private int countPage;
	
	/**
	 *每页显示的信息数量
	 */
	private int sizePage = 1;
	
	/**
	 * 总页数
	 */
	private int maxPage = 0;
	
	/**
	 * 需要进行分页的链接
	 */
	private String urlPage;
	
	/**
	 * 当前页面在数据库中的位置(页面当前位置)
	 */
	private int curPage;
	
	
	/**
	 * 构造替换标签的必须属性
	 * @param urlPage 
	 * 				当前页面的链接 链接地址  http://www.***.com/servlet
	 * @param countPage  
	 * 				需要显示数据的总数量
	 * @param sizePage	
	 * 				 每页显示的信息数量
	 *  @param currentPage 
	 *  			当前页面在数据库中的光标位置
	 * @param htmlContent
	 * 				 原HTML代码
	 */
	public PagePrase(String htmlContent,String urlPage,int countPage,int sizePage,int currentPage){
		super.htmlCotent = htmlContent;
		this.countPage = countPage;
			//除数不能为0
		if(sizePage != 0){
			this.sizePage = sizePage;
		}
		// 判断传入的链接地址后面是否带有？ 没有则自动加上
		if (urlPage.indexOf("?") > 0) {
			this.urlPage  = urlPage + "&";
		} else {
			this.urlPage = urlPage + "?";
		}
		if(currentPage > countPage){
			this.curPage = countPage;
		}else if(currentPage <0){
			this.curPage = 0;
		}else{
			this.curPage = currentPage;
		}
		maxPage();
	}
	
	@Override
	public String parse() {
		// TODO Auto-generated method stub
		//替换首页标签:{ms:page.index}
		super.newCotent = getHomePage();
		String indexHtml = super.replaceFirst(RegexEnum.PAGE_INDEX);
		//替换上一页标签:{ms:page.pre/}
		super.htmlCotent = indexHtml;
		super.newCotent = getPreviousPage();
		String preHtml = super.replaceFirst(RegexEnum.PAGE_PRE);
		//替换下一页标签：{ms:page.next/}
		super.htmlCotent = preHtml;
		super.newCotent = getNextPage();
		String nextHtml = super.replaceFirst(RegexEnum.PAGE_NEXT);
		//替换尾页标签：{ms:page.over/}
		super.htmlCotent = nextHtml;
		super.newCotent = getTrailerPage();
		String traileHtml = super.replaceFirst(RegexEnum.PAGE_OVER);
		return traileHtml;
	}
	
	/**
	 * 计算页面总数
	 */
	private void maxPage(){
		//求余 余数为0 取整为总页数  否则加1
		int remainder = countPage%sizePage;
		if(remainder == 0 ){
			maxPage = countPage-sizePage;
		}else{
			maxPage =  countPage-remainder;
		}
		if(maxPage <0){
			maxPage = 0;
		}
	}
	
	/**
	 * 首页
	 * @return homePagin
	 */
	private String getHomePage(){
		String homePage = urlPage + "seat=0";
		return homePage;
	}
	
	/**
	 * 尾页
	 * @return trailerPagin
	 */
	private String getTrailerPage(){
		String trailerPage = urlPage + "seat="+maxPage;
		return trailerPage;
	}
	
	/**
	 * 下一页
	 * @return nextPagin
	 */
	private String getNextPage(){ 
		String nextPage;
		if(curPage >= 0 && curPage+sizePage < countPage){
			int numCountPage = curPage+sizePage;
			nextPage = urlPage + "seat="+(numCountPage);
		}else {
			nextPage = urlPage + "seat="+maxPage;
		}
		return nextPage;
	}
	
	/**
	 * 上一页
	 * @return previousPage 链接加光标位置
	 */
	private String getPreviousPage(){
		String previousPage;
		if(curPage-sizePage > 0){
			int numCountPage = curPage-sizePage;
			previousPage = urlPage + "seat="+(numCountPage);
		}else {
			previousPage = urlPage + "seat=0";
		}
		return previousPage;
	}
	
}
