package com.mingsoft.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.util.StringUtil;
/**
 * 查看标签解析后的效果
 * 父类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ViewServlet extends BaseServlet {
	
	/**
	 * 实现分页功能时定位页面所在的位置
	 */
	private int beginSize = 0;
	
	protected String htmlComent;
	
	/**
	 * 返回解析完标签后的HTML代码
	 * @param request 
	 * @param response
	 * @param htmlView 需要接解析的HTML页面
	 * @throws ServletException
	 * @throws IOException IO流
	 * @param articleId 文章ID
	 * @param articleTypeId 栏目ID
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		super.doPost(request, response);
		String seat = request.getParameter("seat");
		if(!StringUtil.strNull(seat)){
			beginSize = Integer.parseInt(seat);
		}else{
			beginSize = 0;
		}
	}
	
	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
	}
	
	/**
	 * 读取和解析HTML模版
	 * @param htmlName 模版名称
	 * @param articleNum 文章ID，默认为0时表示不从地址上获取存在
	 * @param articeTypeNum 栏目ID，默认为0时表示不从地址上获取存在
	 * @return
	 */
	protected String getHtml(String htmlName,int articleNum,int articeTypeNum){
		IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,htmlName,beginSize,BASE_URL,articleNum,articeTypeNum);
		String htmlContent = regexHtml.getHtmlTemplate();
		return htmlContent;
	}
}
