package com.mingsoft.servlet.admin.article;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 对修改的文章进行保存
 * @author Administrator
 *				荣繁奎 
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ArticleEditServlet extends BaseServlet{

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		
	}


	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		PrintWriter out = response.getWriter();

		//获取文章的信息
		String articleId = request.getParameter("article_editId");
		String articleTitle = request.getParameter("articleEdit_title");
		String articleContent = request.getParameter("articleEditContentSave");
		String articleAuthor = request.getParameter("articleEdit_author");
		String articleSource = request.getParameter("artilceEdit_source");
		String articleTypeId = request.getParameter("article_edit_articleTypeId");
		String articleImg = request.getParameter("article_img_save");
		//新增字段文章的类型 flag
		String articleFlag = request.getParameter("articleProperty");
		int flag = 0;
		if(articleFlag.equals("c")){
			flag = 1;
		}else if(articleFlag.equals("f")){
			flag = 2;
		}
		int type = 0;
		if(!StringUtil.strNull(articleTypeId)){
		   type = Integer.parseInt(articleTypeId);
		}else{
			request.getRequestDispatcher(JspPage.ARTICLE_EDIT).forward(request, response);
		}
		String str="";
		if(!StringUtil.strNull(articleId)){
			int articleNum = Integer.parseInt(articleId);
			if(StringUtil.strNull(articleTitle)||StringUtil.strNull(articleContent)){
				str = "输入的不符合规定 请重新输入！";
				request.setAttribute("str", str);
				request.getRequestDispatcher(JspPage.ARTICLE_EDIT).forward(request, response);
			}else if(articleTitle.length()>180){
				str = "输入的标题或内容不符合规定， 请重新输入！";
				request.getRequestDispatcher(JspPage.ARTICLE_EDIT).forward(request, response);
			}else{
				ArticleEntity article = new ArticleEntity();
				article.setArticleId(articleNum);
				article.setArticleTitle(articleTitle);
				article.setArticleAuthor(articleAuthor);
				article.setArticleContent(articleContent);
				article.setArticleDate();
				article.setArticleSource(articleSource);
				article.setArticleType(type);
				article.setArticleImg(articleImg);
				article.setArticleFlag(flag);
				IArticleBiz articleBiz = new ArticleBizImpl();
				articleBiz.editEntity(article);
				//当前文章的HTML模版
				String articleHtmlName = RegexConstant.VIEW_NOT_HTML;
				//根据当前蚊子所在的栏目ID取出当前文章的HTML模版
				IArticleTypeBiz articleTypeBiz =  new ArticleTypeBizImpl();
				ArticleTypeEntity articleType = articleTypeBiz.articleTypeSearchWithId(type);
				if(articleType!=null){
					articleHtmlName = articleType.getArticleTypeNewsTem();
				}
				//读取相应的HTML文件并解析
				IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleHtmlName,0,BASE_URL,articleNum,type);
				String htmlContent = regexHtml.getHtmlTemplate();
		        //创建生成静态页面
				CreateHtmlFile.createArticleHtml(BASE_URL_PATH, htmlContent, BASE_URL, article);
			}
			
		}
		out.close();
	}

	
}
