package com.mingsoft.servlet.admin.article;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.text.SimpleDateFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;

/**
 * @author 荣繁奎
 * QQ:10961995990
 * 铭飞科技 www.ming-soft.com
 * @date:2013-11-24 下午03:53:56
 * @version : 点击文章管理的编辑文章跳转页面并对输入框进行赋值
 *
 */
@SuppressWarnings("serial")
public class ArticleLoadServlet extends BaseServlet {

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		super.doPost(request, response);
		PrintWriter out = response.getWriter();
		String articleNum = request.getParameter("articleId");
		int articleId=0;
		if(!StringUtil.strNull(articleNum)){
			articleId = Integer.parseInt(articleNum);
			ArticleEntity article = new ArticleEntity();
			IArticleBiz articleBiz = new ArticleBizImpl();
			article.setArticleId(articleId);
			ArticleEntity articleEntity = articleBiz.selectEntity(article);
			JsonConfig config = new JsonConfig();
			config.registerJsonValueProcessor(Date.class, new JsonValueProcessor() {
				public Object processObjectValue(String arg0, Object arg1,
						JsonConfig arg2) {
					// TODO Auto-generated method stub
					SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
					return sd.format((Date) arg1);
				}
				public Object processArrayValue(Object arg0, JsonConfig arg1) {
					// TODO Auto-generated method stub
					return null;
				}
			});
			String src = JSONObject.fromObject(articleEntity, config).toString();
			out.print(src);
			out.close();
		}
	}

	
}
