package com.mingsoft.servlet.admin.article;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 增加文章进行保存
 * @author Administrator
 *				荣繁奎 
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ArticleSaveServlet extends BaseServlet{

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		request.getRequestDispatcher(JspPage.ARTICLE_SAVE).forward(request, response);
		
		
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		PrintWriter out = response.getWriter();
		
		//获取文章的信息
		String articleTitle = request.getParameter("article_title_save");
		String articleContent = request.getParameter("articleContentSave");
		String articleAuthor = request.getParameter("article_author_save");
		String articleSource = request.getParameter("artilce_source_save"); 
		String articleTypeId = request.getParameter("articleTypeId");
		String articleImg = request.getParameter("article_img_save");
		//新增字段文章的类型 flag
		String articleFlag = request.getParameter("articleProperty");
		int flag = 0;
		if(articleFlag.equals("c")){
			flag = 1;
		}else if(articleFlag.equals("f")){
			flag = 2;
		}
		int articleTypeNum = 0;
		if(!StringUtil.strNull(articleTypeId)){
			articleTypeNum = Integer.parseInt(articleTypeId);   
		
		}
		//如果输入不符合规定则返回一些信息
		String str = "";
		if(StringUtil.strNull(articleTitle)||StringUtil.strNull(articleContent)){
			str = "输入的不符合规定 请重新输入！";
			request.setAttribute("str", str);
			request.getRequestDispatcher(JspPage.ARTICLE_SAVE).forward(request, response);
		}else if(articleTitle.length()>180){
			str = "输入的标题或内容不符合规定， 请重新输入！";
			request.getRequestDispatcher(JspPage.ARTICLE_SAVE).forward(request, response);
		}else{
			ArticleEntity article = new ArticleEntity();
			article.setArticleTitle(articleTitle);
			article.setArticleContent(articleContent);
			article.setArticleType(articleTypeNum);
			article.setArticleSource(articleSource);
			article.setArticleAuthor(articleAuthor);
			article.setArticleDate();
			article.setArticleImg(articleImg);
			article.setArticleFlag(flag);
			IArticleBiz articleBiz = new ArticleBizImpl();
			articleBiz.save(article);
			//抽取当前数据库中文章最大id
	        int aoticleMaxId = articleBiz.findMaxId("article");
	        
			//当前文章的所在HTML模版
			String articleHtmlName = RegexConstant.VIEW_NOT_HTML;
			//根据当前文章所在的栏目ID取出当前文章的HTML模版
			IArticleTypeBiz articleTypeBiz =  new ArticleTypeBizImpl();
			ArticleTypeEntity articleType = articleTypeBiz.articleTypeSearchWithId(articleTypeNum);
			if(articleType!=null){
				articleHtmlName = articleType.getArticleTypeNewsTem();
			}
			//读取相应的HTML文件并解析
			IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleHtmlName,0,BASE_URL,aoticleMaxId,articleTypeNum);
			String htmlContent = regexHtml.getHtmlTemplate();
			 ArticleEntity art = new ArticleEntity();
			 art.setArticleId(aoticleMaxId);
			 art.setArticleType(articleTypeNum);
			//创建生成静态页面
	        CreateHtmlFile.createArticleHtml(BASE_URL_PATH,htmlContent,BASE_URL,art);
		}
		out.close();
	}

}
