package com.mingsoft.servlet.admin.article;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 按照文章标题关键字进行查询
 * @author Administrator
 *	 			荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ArticleSearchServlet extends BaseServlet{

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		
		PrintWriter out = response.getWriter();
		
		String title = request.getParameter("title");
		String articleTypeId = request.getParameter("art");
		List<ArticleEntity> list = null;
		ArticleEntity article = new ArticleEntity();
		IArticleBiz articleBiz = new ArticleBizImpl();
		
		if(!StringUtil.strNull(title)&&StringUtil.strNull(articleTypeId)){
			article.setArticleTitle("%"+title+"%");
			list = articleBiz.searchEntityList(article);
		}else if(!StringUtil.strNull(articleTypeId)&&StringUtil.strNull(title)){
			int articleTypeNum = Integer.parseInt(articleTypeId);
			list = articleBiz.searchArticleType(articleTypeNum);
		}else{
			int articleTypeNum = Integer.parseInt(articleTypeId);
			article.setArticleType(articleTypeNum);
			article.setArticleTitle("%"+title+"%");
			list = articleBiz.searchArtList(article);
		}
			//过滤器 把时间对象转换为String
			JsonConfig config = new JsonConfig();
			config.registerJsonValueProcessor(Date.class, new JsonValueProcessor() {
				public Object processObjectValue(String arg0, Object arg1,
						JsonConfig arg2) {
					// TODO Auto-generated method stub
					SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
					return sd.format((Date) arg1);
				}

				public Object processArrayValue(Object arg0, JsonConfig arg1) {
					// TODO Auto-generated method stub
					return null;
				}
			});

			String str = JSONArray.fromObject(list, config).toString();
			out.write(str);
			out.close();
		
	}

	
}
