package com.mingsoft.servlet.admin.article;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
/**
 * 查看生成的文章模版
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ArticleShowServlet extends BaseServlet {

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		String articleId = request.getParameter(RegexConstant.REGEX_ARTICLE_URL_A);
		int articleIdInt = 0;
		int articleTypeId = 0;
		String articleHtmlName = RegexConstant.VIEW_NOT_HTML;
		if(articleId != null){
			articleIdInt = Integer.parseInt(articleId);
			//根据文章ID取出显示当前文章的模版和所在栏目的ID
			IArticleBiz articleBiz = new ArticleBizImpl();
			ArticleEntity article = new ArticleEntity();
			article.setArticleId(articleIdInt);
			article = articleBiz.selectEntity(article);
			IArticleTypeBiz articleTypeBiz =  new ArticleTypeBizImpl();
			//当前文章所在的栏目ID
			articleTypeId = article.getArticleType();
			ArticleTypeEntity articleType = articleTypeBiz.articleTypeSearchWithId(articleTypeId);
			//当前文章所在的模版
			if(articleType!=null){
				articleHtmlName = articleType.getArticleTypeNewsTem();
			}
			//读取相应的HTML文件并解析
			IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleHtmlName,0,BASE_URL,articleIdInt,articleTypeId);
			String htmlContent = regexHtml.getHtmlTemplate();
			//生成的文章静态HTML的路径
			String articleHtmlUrl = CreateHtmlFile.createArticleHtml(BASE_URL_PATH,htmlContent,BASE_URL,article);
			response.sendRedirect(articleHtmlUrl);
		}
		
	}
	
}
