package com.mingsoft.servlet.admin.articletype;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.io.IoReader;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.PraseImpl;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 添加栏目封面内容的Servlet
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleTypeContentSave extends BaseServlet{
	private static final long serialVersionUID = 1L;

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		String articleTypeId = request.getParameter("arctypeId");
		String articleTypeContent = request.getParameter("articleTypeContent");
		String articleTypeCoverTem = request.getParameter("articleTypeCoverTem");
		IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
		if(!StringUtil.strNull(articleTypeId)){
			int artTypeId = Integer.parseInt(articleTypeId);
			ArticleTypeEntity articleType = new ArticleTypeEntity();
			articleType.setArticleTypeId(artTypeId);
			articleType.setArticleTypeContent(articleTypeContent);
			articleTypeBiz.articleTypeConSave(articleType);
			
			//读取相应的HTML文件并解析
			IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleTypeCoverTem,0,BASE_URL,0,artTypeId);
			String htmlContent = regexHtml.getHtmlTemplate();
			PraseImpl prase = new PraseImpl(htmlContent,articleTypeCoverTem,0,BASE_URL,0,0);
			htmlContent =  prase.replace();
	        //创建生成静态页面
			String url = CreateHtmlFile.createArticleTypeHtml(BASE_URL_PATH,htmlContent,BASE_URL,artTypeId);
			String contentHtmlPath = this.getServletContext().getRealPath(url);
			IoReader.writeFile(htmlContent, contentHtmlPath,"UTF-8");
		}

	}
	
}
