package com.mingsoft.servlet.admin.articletype;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
/**
 * 查看封面模版内容
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class ContentShowServlet extends BaseServlet {

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		//接受链接地址中的栏目ID
		String articleTypeId = request.getParameter(RegexConstant.REGEC_COVER_URL_C);
		int articleTypeIdInt = 0;
		String  articleTypeContent = RegexConstant.VIEW_NOT_HTML;
		if(articleTypeId != null){
			articleTypeIdInt = Integer.parseInt(articleTypeId);
			IArticleTypeBiz articleTypeBiz =  new ArticleTypeBizImpl();
			ArticleTypeEntity articleType = articleTypeBiz.articleTypeSearchWithId(articleTypeIdInt);
			if(articleType != null){
				articleTypeContent = articleType.getArticleTypeCoverTem();
			}
		}
		//读取相应的HTML文件并解析
		IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleTypeContent,0,BASE_URL,0,articleTypeIdInt);
		String htmlContent = regexHtml.getHtmlTemplate();
        //创建生成静态页面
		String articleTyprHtmlUrl = CreateHtmlFile.createArticleTypeHtml(BASE_URL_PATH,htmlContent,BASE_URL,articleTypeIdInt);
        response.sendRedirect(articleTyprHtmlUrl);
	}


}
