package com.mingsoft.servlet.admin.articletype;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONArray;

import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.servlet.BaseServlet;
/**
 * 处理JSP的JSON请求输出数据库中的栏目
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ListArticleTypeServlet extends BaseServlet {

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		super.doGet(request, response);
		if (request.getParameter("type")!=null && request.getParameter("type").equals("json")) {
			doPost(request, response);
		} else {
			request.getRequestDispatcher(JspPage.ARTICLETYPE_LIST).forward(request, response);
		}
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		 super.doPost(request, response);
		 IArticleTypeBiz artucleTypeBiz = new ArticleTypeBizImpl();
		 List<ArticleTypeEntity> articleTypeList = artucleTypeBiz.queryForList();
		 PrintWriter out = response.getWriter();
		 String str = JSONArray.fromObject(articleTypeList).toString();
		 out.write(str);
		 out.close();
	}
}

