package com.mingsoft.servlet.admin.articletype;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 删除栏目信息 
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class RemoveArticleTypeServlet extends BaseServlet{
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		
	}

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		PrintWriter out = response.getWriter();
		//接收要删除栏目的ID
		String articleTypeId= request.getParameter("articleTypeId");
		//将栏目ID传入文章的DAO中如果该栏目下纯在文章则不能删除该栏目，
		ResutEntity re = new ResutEntity();
		
		if(!StringUtil.strNull(articleTypeId)){
			int articleTypeIdBiz = Integer.parseInt(articleTypeId);
			IArticleBiz articleBiz = new ArticleBizImpl();
			List<ArticleEntity> list = articleBiz.searchArticleType(articleTypeIdBiz);
			if(list.size() == 0){
				IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
				ArticleTypeEntity articleType = new ArticleTypeEntity();
				articleType.setArticleTypeId(articleTypeIdBiz);
				articleTypeBiz.delEntity(articleType);
				re.setCode(ResutEntity.ARTICLETYPE_REMOVE_SUCCESS);
			}else{
				re.setCode(ResutEntity.ARTICLETYPE_REMOVE_FAIL);
			}
		}
		out.write(JSONObject.fromObject(re).toString());
		out.close();
		
	}
	
 }
