package com.mingsoft.servlet.admin.articletype;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.servlet.BaseServlet;
/**
 * 添加栏目信息的Servlet
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class SaveArticleTypeServlet extends BaseServlet {
	private static final long serialVersionUID = 1L;

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		//获取外部提交的栏目信息
		super.doPost(request, response);
		String coverTem = null;
		String listTem = null;
		String newsTem = null;
		String name = request.getParameter("name");
		String url = request.getParameter("url");
		String keyword = request.getParameter("keyword");
		String descrip = request.getParameter("descrip");
		int quality = 1;
		int pid = 0;
		if(request.getParameter("quality") != null){
			quality = Integer.parseInt(request.getParameter("quality"));
		}
		switch (quality) {
		case 1:
			newsTem = request.getParameter("news_tem");
			listTem = request.getParameter("list_tem");
			break;
		case 2:
			coverTem = request.getParameter("cover_tem");
			break;
		}
		
		if(!request.getParameter("articleTypeText").equals("")){
				pid = Integer.parseInt(request.getParameter("articleTypeText"));
		}		
		//将后去到的栏目信息存放在ArticleTypeEntity对象中
		ArticleTypeEntity articleType = new ArticleTypeEntity();
		articleType.setArticleTypeName(name);
		articleType.setArticleTypeUrl(url);
		articleType.setArticleTypeKeyword(keyword);
		articleType.setArticleTypeCoverTem(coverTem);
		articleType.setArticleTypeListTem(listTem);
		articleType.setArticleTypeNewsTem(newsTem);
		articleType.setArticleTypeDescrip(descrip);
		articleType.setArticleTypeQuality(quality);
		articleType.setArticleTypePid(pid);
		//通过Biz将栏目信息存入数据库
		IArticleTypeBiz articleTypeBiz = new ArticleTypeBizImpl();
		articleTypeBiz.saveEntity(articleType);
		//数据提交成功返回true
		PrintWriter out = response.getWriter();
		out.print("true");
		out.close();
		
	}

}
