package com.mingsoft.servlet.admin.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.biz.IWebBiz;
import com.mingsoft.biz.impl.WebBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.io.IoReader;
import com.mingsoft.regex.impl.PraseImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
/**
 * 生成并保存用户选择的主页模版
 * @author 
 * 			荣繁奎
 * QQ:1096199590
 * 铭飞科技 
 * 官网 www.ming-soft.com
 */
@SuppressWarnings("serial")
public class HomePageCreateServlet extends BaseServlet{

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		if(request.getParameter("type")!=null || request.getParameter("type")=="json"){
			doPost(request, response);
		}else{
			request.getRequestDispatcher(JspPage.HOMGPSGECREATE_SAVE).forward(request, response);
		}
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		String url = request.getParameter("url");
		String position = request.getParameter("position");
		IWebBiz webBiz = new WebBizImpl(); 
		WebEntity web = webBiz.queryWebInfo(1);
		//-----------------------------读取模版路径----------------------------------------------		
		//获取模版名称
		String tempLate = web.getWebStyle();
		String path = this.getServletContext().getRealPath(RegexConstant.REGEX_SAVE_TEMPLATE)+JspPage.PATH_SYMBOL+tempLate;
		//模版路径加上(用户选择的主页的模版的路径)default/index.html
		String urlName = path+JspPage.PATH_SYMBOL+url;
		//获取文件所在路径 首先判断用户输入的模版文件是否存在
		File file = new File(urlName);
		ResutEntity re = new ResutEntity();
		if(!file.exists()){
			//不存在返回弹出框提示
			re.setCode(ResutEntity.TEMPLET_NO_EXISTS);
		}else{
			//判断根目录下是否存在index.htm文件 存在的话直接替换 不存在的话在此目录下进行创建主页index.htm文件
			String homePagePath = this.getServletContext().getRealPath(position);
			//------替换模版标签-----------------------------------------------------------------
			String html = url;
			//从数据库取出网站信息
			//-----------------------------读取模版路径----------------------------------------------		
			//获取当前项目的物理路径
			String paths = this.getServletContext().getRealPath("");
			//当前模版的物理路径
			String pathTemp = paths+JspPage.PATH_SYMBOL+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+tempLate;
			//IO流读取模版
			String htmlComent = IoReader.readFile(pathTemp+JspPage.PATH_SYMBOL+html);
			//-----------------------------读取模版路径----------------------------------------------
			if(!StringUtil.strNull(htmlComent)){
				//获取列表在数据库中的位置
				String seat = request.getParameter("seat");
				int curNum = 0;
				if(!StringUtil.strNull(seat)){
					curNum = Integer.parseInt(seat);
				}
				//项目的相对路径
				String msCmsUrl = BASE_URL;
				//解析HTML上的标签
				PraseImpl prase = new PraseImpl(htmlComent,pathTemp,curNum,msCmsUrl,0,0);
				htmlComent =  prase.replace();
			}else{
				//提示错误：未找到模版
				htmlComent = pathTemp+JspPage.PATH_SYMBOL+html + "("+RegexConstant.VIEW_NOT_HTML+")";
			}
			
			//------替换模版标签-----------------------------------------------------------------
			IoReader.writeFile(htmlComent, homePagePath,"UTF-8");
			re.setCode(ResutEntity.HOMEPAGE_CREATED);
		}
		PrintWriter out = response.getWriter();
		out.write(JSONObject.fromObject(re).toString());
		out.close();
	}

}
