package com.mingsoft.servlet.admin.web;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.biz.IUserBiz;
import com.mingsoft.biz.impl.UserBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;

/**
 * 系统密码修改 控制层
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public class PasswordEditServlet extends BaseServlet {

	/**
	 * 版本号
	 */
	private static final long serialVersionUID = 1L;


	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
			super.doGet(request, response);
			if (request.getParameter("type")!=null && request.getParameter("type").equals("json")) {
				
			} else {
				request.getRequestDispatcher(JspPage.PASSWORD_EDIT).forward(request, response);
			}
	}

	/**
	 * 密码修改
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
			super.doPost(request, response);
			IUserBiz userBiz = new UserBizImpl();
			PrintWriter out = response.getWriter();
			String oldPassword = request.getParameter("oldPassword");
			String newPassword = request.getParameter("newPassword");
			String againPassword = request.getParameter("againPassword");
			String password = userBiz.queryName("admin");
			ResutEntity re = new ResutEntity();
			if(!oldPassword.equals(password)){
				re.setCode(ResutEntity.OLD_PASSWORD_ERROE);
			} else if(StringUtil.strNull(newPassword)){
				re.setCode(ResutEntity.NEW_PASSWORD_CANNOT_EMPTY);
			} else if(StringUtil.minLeng(newPassword, 5) || StringUtil.maxLeng(newPassword, 18)){
				re.setCode(ResutEntity.PASSWORD_LENGTH);
			} else if(!againPassword.equals(newPassword)){
				re.setCode(ResutEntity.NEW_PASSWORD_DISACCORD);
			} else {
				userBiz.editPassword("admin", newPassword);
				re.setCode(ResutEntity.PASSWORD_EDIT_SUCCESS);
			}
			out.print(JSONObject.fromObject(re).toString());
			out.close();
	}
}
