package com.mingsoft.servlet.admin.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.biz.IWebBiz;
import com.mingsoft.biz.impl.ArticleBizImpl;
import com.mingsoft.biz.impl.ArticleTypeBizImpl;
import com.mingsoft.biz.impl.WebBizImpl;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.io.CreateHtmlFile;
import com.mingsoft.io.IoReader;
import com.mingsoft.regex.IRegexHtml;
import com.mingsoft.regex.impl.PraseImpl;
import com.mingsoft.regex.impl.RegexHtmlImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;

/**
 * @author 荣繁奎
 * QQ:1096199590
 * 铭飞科技
 * 官网 ：www.ming-soft.com
 * @date:2013-11-1 上午09:22:05
 * @version :一键更新网站 跳转页面 完成网站的更新 静态页面重新生成
 *
 */
@SuppressWarnings("serial")
public class UpdateWebServlet extends BaseServlet {


	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		request.getRequestDispatcher(JspPage.UPDATE_WEB).forward(request, response);
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
		Map<String,String> strMap = new HashMap<String, String>();
		PrintWriter out = response.getWriter();
		//接收页面传来的参数
		String up = request.getParameter("update");
		ResutEntity re = new ResutEntity();
		int n = 0;
		if(!StringUtil.strNull(up)&&up.equals("update")){
			//当前文章的所在HTML模版
			String articleHtmlName = RegexConstant.VIEW_NOT_HTML;
			IArticleBiz articleBiz = new ArticleBizImpl();
			List<ArticleEntity> list = articleBiz.queryListForAll();
			IArticleTypeBiz articleTypeBiz =  new ArticleTypeBizImpl();
			for(int i=0;i<list.size();i++){
				n = 8;
				ArticleEntity art = list.get(i);
				int articleNum = art.getArticleId();
				int articleTyprId = art.getArticleType();
				
				//根据当前蚊子所在的栏目ID取出当前文章的HTML模版
				ArticleTypeEntity articleType = articleTypeBiz.articleTypeSearchWithId(articleTyprId);
				if(articleType!=null){
					articleHtmlName = articleType.getArticleTypeNewsTem();
				}
				//读取相应的HTML文件并解析---------------------------------
				IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleHtmlName,0,BASE_URL,articleNum,articleTyprId);
				
				//将HTML存入Map中
				strMap.put("articleHtml", regexHtml.getHtmlTemplate());
				
		        //创建生成静态页面
		        CreateHtmlFile.createArticleHtml(BASE_URL_PATH,strMap.get("articleHtml"),BASE_URL,art);
		        //释放内存
		        regexHtml = null;
 			}
			
			//接受链接地址中的栏目ID
			List<ArticleTypeEntity> listArtType = articleTypeBiz.queryListForCover(2); 
			for(int j=0;j<listArtType.size();j++){
				n = 8;
				ArticleTypeEntity artType = (ArticleTypeEntity)listArtType.get(j);
				int articleTypeId = artType.getArticleTypeId();
				String articleTypeContent = artType.getArticleTypeCoverTem();
				//读取相应的HTML文件并解析
				IRegexHtml regexHtml = new RegexHtmlImpl(BASE_URL_PATH,articleTypeContent,0,BASE_URL,0,articleTypeId);
				
				//将HTML存入Map中
				strMap.put("linkHtml", regexHtml.getHtmlTemplate());
		        //创建生成静态页面
				CreateHtmlFile.createArticleTypeHtml(BASE_URL_PATH,strMap.get("linkHtml"),BASE_URL,articleTypeId);
				//释放内存
				regexHtml= null;
			}

			//生成主页
			IWebBiz webBiz = new WebBizImpl(); 
			WebEntity web = webBiz.queryWebInfo(1);
			//-----------------------------读取模版路径----------------------------------------------		
			//获取模版名称
			String tempLate = web.getWebStyle();
			String path = this.getServletContext().getRealPath(RegexConstant.REGEX_SAVE_TEMPLATE)+JspPage.PATH_SYMBOL+tempLate;
			//模版路径加上(用户选择的主页的模版的路径)default/index.html
			String urlName = path+JspPage.PATH_SYMBOL+RegexConstant.REGEX_INDEX_HTML;
			//获取文件所在路径 首先判断用户输入的模版文件是否存在
			File file = new File(urlName);
			if(!file.exists()){
				//不存在返回弹出框提示
				re.setCode(ResutEntity.TEMPLET_NO_EXISTS);
			}else{
				//判断根目录下是否存在index.htm文件 存在的话直接替换 不存在的话在此目录下进行创建主页index.htm文件
				String homePagePath = this.getServletContext().getRealPath(JspPage.INDEX_HTML);
				//-----------------------------读取模版路径----------------------------------------------		
				//获取当前项目的物理路径
				String paths = this.getServletContext().getRealPath("");
				//当前模版的物理路径
				String pathTemp = paths+JspPage.PATH_SYMBOL+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+tempLate;
				//IO流读取模版
				String htmlComent = IoReader.readFile(pathTemp+JspPage.PATH_SYMBOL+JspPage.INDEX_HTML);
				//-----------------------------读取模版路径----------------------------------------------
				if(!StringUtil.strNull(htmlComent)){
					//获取列表在数据库中的位置
					String seat = request.getParameter("seat");
					int curNum = 0;
					if(!StringUtil.strNull(seat)){
						curNum = Integer.parseInt(seat);
					}
					//项目的相对路径
					String msCmsUrl = BASE_URL;
					//解析HTML上的标签
					PraseImpl prase = new PraseImpl(htmlComent,pathTemp,curNum,msCmsUrl,0,0);
					htmlComent =  prase.replace();
					prase = null;
				}else{
					//提示错误：未找到模版
					htmlComent = pathTemp+JspPage.PATH_SYMBOL+JspPage.INDEX_HTML + "("+RegexConstant.VIEW_NOT_HTML+")";
				}
				
				//------替换模版标签-----------------------------------------------------------------
				IoReader.writeFile(htmlComent, homePagePath,"UTF-8");
				re.setCode(ResutEntity.HOMEPAGE_CREATED);
			}
			strMap = null;
		}
		re.setCode(n);
		out.print(JSONObject.fromObject(re).toString());
		out.close();
	}

}
