package com.mingsoft.servlet.admin.web;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import com.mingsoft.constant.JspPage;
import com.mingsoft.entity.WebLogo;
import com.mingsoft.servlet.BaseServlet;
 
/**
 * 上传图片的 控制层
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class UploadImgServlet extends BaseServlet {

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

	}

	/**
	 * 网站LOGO上传
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
			//配置上传组件ServletFileUpload 
			ServletFileUpload uploadHandler = new ServletFileUpload(new DiskFileItemFactory());
	        PrintWriter writer = response.getWriter();
	        response.setContentType("application/json");
	        
	        try {
	            List<FileItem> items = uploadHandler.parseRequest(request);
	            for (FileItem item : items) {
	            	//isFormField判断一个item类对象封装的是一个普通的表单字段还是文件表单字段。
	                // 如果item是文件域，则做出如下处理：
	                if (!item.isFormField()) {	
	                	//上传文件域的Name 
	                    String fileName = item.getName();
	                    //截取扩展名
	                    int idx = fileName.lastIndexOf(".");    
	                    String extension = fileName.substring(idx);  
	                    //获取文件名
	                    String webLogo = new Date().getTime() + extension;
	                    //得到文件夹的物理路径
	                    String path = this.getServletContext().getRealPath("upload");
	                    URLEncoder.encode(path,"UTF-8");
	                   //创建一个File
	                    File file = new File(path + JspPage.PATH_SYMBOL + webLogo);
	                    request.setAttribute("articleImg", file);
	                    item.write(file);
	        			WebLogo image = new WebLogo();
	        			image.setName(webLogo);
	        			image.setSize(1);
	        			image.setType("image\\/jpeg");
	        			image.setUrl(JspPage.PATH_SYMBOL+"upload"+JspPage.PATH_SYMBOL+webLogo);
	        			image.setThumbnailUrl("");
	        			image.setDeleteUrl("");
	        			image.setDeleteUrl("");
	        			
	        			JSONObject json = new JSONObject();
	        			json.put("files", image);

	        			response.setContentType("text/html;charset=utf-8");
	        			writer.write(json.toString());
	        			writer.flush();
	                    writer.close();	
	                }
	            }
	        } catch (Exception e) {
	                throw new RuntimeException(e);
	        } 
	        
	        	
	}

}
