package com.mingsoft.servlet.admin.web;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.biz.IWebBiz;
import com.mingsoft.biz.impl.WebBizImpl;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
 
/**
 * 网站初始化的 控制层
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class WebSaveServlet extends BaseServlet {

	/**
	 * 保存修改的网站信息
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
			super.doGet(request, response);	
	}


	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {	
			super.doPost(request, response);
			WebEntity webentity = new WebEntity(); 
			IWebBiz webBiz = new WebBizImpl();
			PrintWriter out = response.getWriter();
			String webTitle = request.getParameter("webTitle");
			String webRealmName = request.getParameter("webRealmName");
			String webLogo = request.getParameter("files[]");
			String webKeyword = request.getParameter("webKeyword");
			String webStyle = request.getParameter("webStyle");
			String webDescrip = request.getParameter("webDescrip");
			String webCopyright = request.getParameter("webCopyright");
			webentity.setWebId(1);
			webentity.setWebTitle(webTitle);
			webentity.setWebRealmName(webRealmName);
			webentity.setWebLogo(webLogo);
			webentity.setWebKeyword(webKeyword);
			webentity.setWebStyle(webStyle);
			webentity.setWebDescrip(webDescrip);
			webentity.setWebCopyright(webCopyright);
			ResutEntity re = new ResutEntity();
			if(StringUtil.strNull(webTitle)){
				re.setCode(ResutEntity.WEBTITLE_CANNOT_EMPTY);
			} else if(StringUtil.minLeng(webTitle, 5) || StringUtil.maxLeng(webTitle, 18)){
				re.setCode(ResutEntity.WEBTITLE_LENGTH);
			} else if(StringUtil.strNull(webRealmName)){
				re.setCode(ResutEntity.WEBREALMNAME_CANNOT_EMPTY);
			} else {
				webBiz.editWebInfo(webentity);
				re.setCode(ResutEntity.WEBINFO_EDIT_SUCCESS);
			}
			out.print(JSONObject.fromObject(re).toString());
			out.close();
	}
}
