package com.mingsoft.servlet.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;

import com.mingsoft.constant.ArticleConstant;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.jdbc.C3p0Connection;
import com.mingsoft.servlet.BaseServlet;

/**
 * 用户安装过程中的数据 及配置文件修改
 * @author 荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
@SuppressWarnings("serial")
public class AlterDbServlet extends BaseServlet {

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doGet(request, response);
		
	}

	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		super.doPost(request, response);
    	PrintWriter out = response.getWriter();
		String myPath = this.getServletContext().getRealPath(ArticleConstant.INSTALL_PATH);
	    File f = new File(myPath);
	    ResutEntity re = new ResutEntity();
	    if(f.exists()){
	    	re.setCode(1);
	    }else{
			// 获取表单中数据库主机
			String dbhost = request.getParameter("dbhost");
			// 获取表单中数据库名
			String dbname = request.getParameter("dbname");
			
			//更改c3p0的配置文件的用户名和密码
			String saveDbUser = request.getParameter("dbuser");
			String saveDbPwd = request.getParameter("dbpwd");
			
			// 获取表单中数据库用户名
			String dbUser = "-u"+saveDbUser;
	
			// 获取表单中数据库密码
			String dbPwd = "-p"+saveDbPwd;
			
			//数据库链接
			String jdbcUrl = "jdbc:mysql://"+dbhost+":3306/"+dbname+"?characterEncoding=utf8";
			
			
			//更新c3p0配置文件开始
			Properties pro = new Properties();
			String c3p0Properties = this.getClass().getClassLoader().getResource("c3p0.properties").getPath();
			c3p0Properties = URLDecoder.decode(c3p0Properties,"utf-8");
			File c3p0File = new File(c3p0Properties);//配置文件对象
			pro.load(new FileInputStream(c3p0File));
			pro.setProperty("c3p0.jdbcUrl", jdbcUrl);
			pro.setProperty("c3p0.password", saveDbPwd);
			pro.setProperty("c3p0.user", saveDbUser);
			pro.store(new FileOutputStream(c3p0File),null);
			//更新c3p0配置文件结束
			 C3p0Connection.updateC3p0(c3p0Properties);
		    //数据文件位置路径
		    String path = this.getServletContext().getRealPath(ArticleConstant.JDBC_PATH);
		   
		    //执行导入数据库的命令 
			String savePath = "mysql "+dbUser+" "+dbPwd+" "+dbname + " "+ "--default-character-set=utf8" + " <"+path;
		    File file = new File(path);
		    if(file.exists()){
		    	re.setCode(2);
		    	Properties prop = System.getProperties();
				String os = prop.getProperty("os.name");
				if(os.startsWith("Win")){
					String[] command  = { "cmd", "/c", savePath};
					Runtime.getRuntime().exec(command);
		    	}else{
		    		String[] command  = {"/bin/sh", "-c", savePath};
					Runtime.getRuntime().exec(command);
		    	}
		    }else{
		    	String content = "您的安装包user文件夹下的数据库"+file.getName()+"文件未找到！"+"请仔细检查是否存在！";
		    	re.setCode(3);
		    	re.setContent(content);
		    }
		    
		   
		}
	    out.print(JSONObject.fromObject(re).toString());
		out.close();
	}

	
}
