package com.mingsoft.servlet.install;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;


import com.mingsoft.biz.IUserBiz;
import com.mingsoft.biz.impl.UserBizImpl;
import com.mingsoft.constant.ArticleConstant;
import com.mingsoft.constant.JspPage;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.entity.ResutEntity;
import com.mingsoft.io.IoReader;
import com.mingsoft.regex.impl.PraseImpl;
import com.mingsoft.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;

/**
 * @author 荣繁奎
 * QQ:1096199590
 * 铭飞科技
 * @date:2013-11-11 下午07:58:45
 * @version : 安装步骤的跳转页面 
 *
 */
@SuppressWarnings("serial")
public class InstallThirdServlet extends BaseServlet {

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		super.doPost(request, response);
		PrintWriter out = response.getWriter();
		//安装完成后的安装步骤重命名
		String firPath = this.getServletContext().getRealPath(JspPage.INSTALL_FIRST);
	    File f = new File(firPath);
	    if(f.exists()){
	    	String p = this.getServletContext().getRealPath(JspPage.INSTALL_FIRST_BAK);
	    	File file = new File(p);
	    	f.renameTo(file);
	    }
	    String secPath = this.getServletContext().getRealPath(JspPage.INSTALL_SECOND);
	    File secFile = new File(secPath);
	    if(secFile.exists()){
	    	String p = this.getServletContext().getRealPath(JspPage.INSTALL_SECOND_BAK);
	    	File file = new File(p);
	    	secFile.renameTo(file);
	    }
	  
	    //修改后台登录的帐号和密码  获取表单中管理员用户名
		String adminUser = request.getParameter("adminuser");

		// 获取表单中管理员密码
		String adminPwd = request.getParameter("adminpwd");
		
		 ResutEntity re = new ResutEntity();
		 re.setCode(ResutEntity.FORWARD_THIRD);
		//修改数据库中管理员用户名及密码
		if(!StringUtil.strNull(adminUser)&&!StringUtil.strNull(adminPwd)){
			 IUserBiz userBiz = new UserBizImpl();
			 userBiz.updataRoot(adminUser,adminPwd);
		}

	    
	  //创建标记性文件夹
	    String myPath = this.getServletContext().getRealPath(ArticleConstant.INSTALL_PATH);
	    File fileMaker = new File(myPath);
	    fileMaker.createNewFile();

	    /**
	     * 生成主页
	     */
	    String urlName = this.getServletContext().getRealPath(RegexConstant.REGEX_SAVE_TEMPLATE)+JspPage.PATH_SYMBOL+ArticleConstant.INDEX_TEMPLATE+JspPage.PATH_SYMBOL+RegexConstant.REGEX_INDEX_HTML;
	    String homePagePath = this.getServletContext().getRealPath(JspPage.INDEX_HTML);
		
		//获取当前项目的物理路径
		String paths = this.getServletContext().getRealPath("");
		//当前模版的物理路径
		String pathTemp = paths+JspPage.PATH_SYMBOL+RegexConstant.REGEX_SAVE_TEMPLATE+JspPage.PATH_SYMBOL+ArticleConstant.INDEX_TEMPLATE;
		//IO流读取模版
		String htmlComent = IoReader.readFile(urlName);
		//-----------------------------读取模版路径----------------------------------------------
			//获取列表在数据库中的位置
		String seat = request.getParameter("seat");
		int curNum = 0;
		if(!StringUtil.strNull(seat)){
			curNum = Integer.parseInt(seat);
		}
		//项目的相对路径
		String msCmsUrl = BASE_URL;
		//解析HTML上的标签
		PraseImpl prase = new PraseImpl(htmlComent,pathTemp,curNum,msCmsUrl,0,0);
		htmlComent =  prase.replace();
		
		//------替换模版标签-----------------------------------------------------------------
		IoReader.writeFile(htmlComent, homePagePath,"UTF-8");
	
		out.print(JSONObject.fromObject(re).toString());
		out.close();
	}

}
