package com.mingsoft.util;
/**
 * 对页面信息进行分页处理
 * 用“seat”作为分页的固定变量属性携带名称
 * 传入构造的链接格式有：“链接名?(此处默认为seat=)”,
 * “连接名?参数名=‘参数’&(此处默认为seat=)”两种（urlPage + "seat="+maxPage;）
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public final class PageUtil {
	/**
	 * 需要显示数据的总数量
	 */
	private int countPage;
	
	/**
	 *每页显示的信息数量
	 */
	private int sizePage;
	
	/**
	 * 总页数
	 */
	private int maxPage = 0;
	
	/**
	 * 需要进行分页的链接
	 */
	private String urlPage;
	
	/**
	 * 当前页面在数据库中的位置(页面当前位置)
	 */
	private int currentPage;
	

	
	/**
	 * 构造必须属性的初始值
	 * @param urlPage 当前页面的链接
	 * @param countPage  需要显示数据的总数量
	 * @param sizePage 每页显示的信息数量
	 * @param currentPage 当前页面在数据库中的位置
	 */
	public PageUtil(String urlPage,int countPage,int sizePage,int currentPage){
		this.countPage = countPage;
		this.sizePage = sizePage;
		this.urlPage = urlPage;
		if(currentPage > countPage){
			this.currentPage = countPage;
		}else if(currentPage <0){
			this.currentPage = 0;
		}else{
			this.currentPage = currentPage;
		}
		maxPage();
	}
	
	/**
	 * 计算页面总数
	 */
	private void maxPage(){
		int v = countPage%sizePage;
		if(v == 0 ){
			maxPage = countPage - sizePage;
		}else{
			maxPage = countPage - v;
		}
	}
	
	/**
	 * 首页
	 * @return homePagin
	 */
	public String getHomePage(){
		String homePage = urlPage + "seat=0";
		return homePage;
	}
	
	/**
	 * 尾页
	 * @return trailerPagin
	 */
	public String getTrailerPage(){
		String trailerPage = urlPage + "seat="+maxPage;
		return trailerPage;
	}
	
	/**
	 * 下一页
	 * @return nextPagin
	 */
	public String getNextPage(){ 
		String nextPage;
		if(currentPage >= 0 && currentPage+sizePage < countPage){
			int numCountPage = currentPage+sizePage;
			nextPage = urlPage + "seat="+(numCountPage);
		}else {
			nextPage = urlPage + "seat="+ maxPage;
		}
		return nextPage;
	}
	
	/**
	 * 上一页
	 * @return previousPage
	 */
	public String getPreviousPage(){
		String previousPage;
		if(currentPage-sizePage > 0){
			int numCountPage = currentPage-sizePage;
			previousPage = urlPage + "seat="+(numCountPage);
		}else {
			previousPage = urlPage + "seat=0";
		}
		return previousPage;
	}
}
