package com.mingsoft.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.mingsoft.regex.Regex;
import com.mingsoft.regex.RegexEnum;
/**
 * 解析模版中正则表达式的工具类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class RegexUtil {
	/**
	 * 读取标签中的属性
	 * @param html 带标签属性的HTML模版
	 * @param regex 定位标签的正则表达式
	 * @param find 属性所在正则的位置
	 * @return 解析出来的属性
	 */
	public static String nature(String html,RegexEnum regex,int find){
		String nuture = null;
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(html);
		if(matcher.find(find)){
			nuture = matcher.group(find);
		}
		return nuture;
	}
	
	public static List<String> natureAll(String html,RegexEnum regex,int find){
		List<String> natureAll = new ArrayList<String>();
		Pattern pattern = Pattern.compile(regex.getRegex());
		Matcher matcher = pattern.matcher(html);
		while(matcher.find()){
			natureAll.add(matcher.group(find));
		}
		return natureAll;
	}
	
	/**
	 * 查找当前标签在模版中的数量
	 * @param html 模版
	 * @param regex 标签
	 * @return 标签的数量
	 */
	public static int regexNum(String html,RegexEnum regex){
        Pattern patternList = Pattern.compile(regex.getRegex());
        Matcher matcherList = patternList.matcher(html);
        int i=0;
        while (matcherList.find()) {
        	i++;
        }
		return i;
	} 
	
	/**
	 * 当标签解析完成后释放内存
	 * @param htmlConment 原Html代码
	 * @param regex 解析方法
	 * @return 解析成功放回解析后的HTML，解析失败返回原HTML代码；
	 */
	public static String regexNull(String htmlConment,Regex regex){
		String htmlNewCon = regex.parse();
		//释放内存
		regex = null;
		if(StringUtil.strNull(htmlNewCon)){
			htmlNewCon = htmlConment;
		}
		return htmlNewCon;
	}
	
}
