package com.mingsoft.util;
/**
 * 对字符串进行判断的工具
 * 可判断：字符串的长度，是否有值
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public final class StringUtil {
	/**
	 * 判断字符串的最大长度
	 * @param str 需要判断的字符
	 * @param max 字符串的最大长度
	 * @return 超过最大长度返回true
	 */
	public static boolean maxLeng(String str,int max){
		if(str.length()> max){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 判断字符串的最小长度
	 * @param str 需要判断的字符串
	 * @param min 字符串的最小长度
	 * @return 没有超过最小长度返回true
	 */
	public static boolean minLeng(String str,int min){
		if(str.length()< min){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 判断字符串长度在一个范围内
	 * @param str 需要判断的字符串长度
	 * @param max 字符串长度的最大值
	 * @param min 字符串长度的最小值
	 * @return 在该范围内返回true
	 */
	public static boolean rangeLeng(String str,int max,int min){
		if(str.length()> min && str.length()< max){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 判断字符串的长度是否等于某个值
	 * @param str 需要判断的字符串
	 * @param equal 字符串的长度值
	 * @return 字符串的长度等于该值返回 true
	 */
	public static boolean equalLeng(String str,int equal){
		if(str.length() == equal){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	*显示错误信息。并提示返回
	*msg:信息内容
	*backUrl:返回地址
	*/
	public static String showMsg(String msg,String backUrl) {
		String linkStr = "<a href='"+backUrl+"'>back</a>";
		msg = "<font style='color:red' >"+msg+"</font>";
		return msg + linkStr; 
	}
	
	/**
	 * 判断字符串是否为空
	 * @param str 需要判断的字符串
	 * @return 如果字符串为空则返回true
	 */
	public static boolean strNull(String str) {
   		if(str == null || str.equals("") || str.trim().length() == 0){
   			return true;
   		}
   		return false;
	}
	
	/**
	 * 变量形态转换
	 * int型转为String型
	 * @param comment
	 * @return
	 */
	public static String intSrt(int comment){
		String srt = "";
		srt = Integer.toString(comment);
		return srt;
	}
	
	/**
	 * 当传入的值为NULL是将其转化为String
	 * @param str
	 * @return""
	 */
	public static String srtingNull(String str){
   		if(str == null || str.equals("") || str.trim().length() == 0){
   			return str = "";
   		}
   		return str;
	}
	
	/**
	 * 限制for循环的次数
	 * @param forInt 最大循环次数
	 * @param constrain 当前循环次数
	 * @return 超过最大循环次数 true
	 */
	public static boolean constraintFor(int forInt,int constrain){
		if(((constrain-1) > forInt && forInt != 1)||((constrain-2) == forInt && forInt == 1)){
			return true;
		}
		return false;
	}
	
	/**
	 * 根据Key限定组合，主要针对Sql语句
	 * @param prmOne 第一个值
	 * @param prmTwo 第二个值
	 * @param prmFirst 对应第一个值的SQL语句
	 * @param prmSecond 对应第二个值的SQL语句
	 * @return
	 */
	public static String restrictGroup(int prmOne,int prmTwo,String prmFirst,String prmSecond){
			String group = prmFirst + " and " + prmSecond;
			if(prmOne == 0){
				group = prmSecond;
			}else if(prmTwo == 0){
				group = prmFirst;
			}
		return group;
	}
	
	/**
	 * 将String型转换成Int型并判断String是否是NULL
	 * @param str
	 * @return int
	 */
	public static int StrInt(String str){
		int valueInt = 0;
		if(!StringUtil.strNull(str)){
			valueInt = Integer.parseInt(str);
		}
		return valueInt;
	}
}
