/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.policy;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import com.whirlycott.cache.policy.CountComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LFUMaintenancePolicy
implements CacheMaintenancePolicy {
    private static final Log log = LogFactory.getLog((Class)(class$com$whirlycott$cache$policy$LFUMaintenancePolicy == null ? (class$com$whirlycott$cache$policy$LFUMaintenancePolicy = LFUMaintenancePolicy.class$("com.whirlycott.cache.policy.LFUMaintenancePolicy")) : class$com$whirlycott$cache$policy$LFUMaintenancePolicy));
    protected ManagedCache managedCache = null;
    protected int maxSize;
    static /* synthetic */ Class class$com$whirlycott$cache$policy$LFUMaintenancePolicy;

    public void performMaintenance() {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("LFUMaintenancePolicy.performing_lfu_maintenance"));
            Object[] objectArray = new Object[]{new Integer(this.maxSize), new Integer(this.managedCache.size())};
            log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.report_items", objectArray));
        }
        if (this.maxSize < (n = this.managedCache.size())) {
            Object[] objectArray;
            if (log.isDebugEnabled()) {
                objectArray = new Object[]{new Integer(n - this.maxSize)};
                log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.clearing_approximately", objectArray));
            }
            objectArray = new ArrayList(new ConcurrentHashMap((Map)this.managedCache).entrySet());
            Collections.sort(objectArray, new CountComparator());
            List list = objectArray.subList(0, n - this.maxSize);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry == null) continue;
                this.managedCache.remove(entry.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(Messages.getString("LFUMaintenancePolicy.new_size") + this.managedCache.size()));
            }
        }
    }

    public void setCache(ManagedCache managedCache) {
        this.managedCache = managedCache;
    }

    public void setConfiguration(CacheConfiguration cacheConfiguration) {
        this.maxSize = cacheConfiguration.getMaxSize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

