/*
 * Decompiled with CFR 0.152.
 */
package com.tenpay.helper;

import com.tenpay.bean.PayRequest;
import com.tenpay.util.MD5Util;
import com.tenpay.util.TenpayUtil;

public class PayRequestHelper {
    private String key;
    private PayRequest payRequest;
    private String sign;
    private final String targetURL = "https://www.tenpay.com/cgi-bin/v1.0/pay_gate.cgi";
    private String requestParameters;

    public PayRequestHelper(String key, PayRequest payRequest) {
        this.key = key;
        this.payRequest = payRequest;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public PayRequest getPayRequest() {
        return this.payRequest;
    }

    public void setPayRequest(PayRequest payRequest) {
        this.payRequest = payRequest;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getTargetURL() {
        return "https://www.tenpay.com/cgi-bin/v1.0/pay_gate.cgi";
    }

    public String getSendUrl() {
        this.createRequestParameters();
        return this.targetURL + "?" + this.requestParameters;
    }

    protected void createSign() {
        StringBuffer buf = new StringBuffer();
        TenpayUtil.addParameter(buf, "cmdno", this.payRequest.getCmdno());
        TenpayUtil.addParameter(buf, "date", this.payRequest.getDate());
        TenpayUtil.addParameter(buf, "bargainor_id", this.payRequest.getBargainor_id());
        TenpayUtil.addParameter(buf, "transaction_id", this.payRequest.getTransaction_id());
        TenpayUtil.addParameter(buf, "sp_billno", this.payRequest.getSp_billno());
        TenpayUtil.addParameter(buf, "total_fee", this.payRequest.getTotal_fee() + "");
        TenpayUtil.addParameter(buf, "fee_type", this.payRequest.getFee_type());
        TenpayUtil.addParameter(buf, "return_url", this.payRequest.getReturn_url());
        TenpayUtil.addParameter(buf, "attach", this.payRequest.getAttach());
        this.requestParameters = buf.toString();
        TenpayUtil.addParameter(buf, "key", this.key);
        this.sign = MD5Util.MD5Encode(buf.toString()).toUpperCase();
    }

    protected void createRequestParameters() {
        this.createSign();
        StringBuffer buf = new StringBuffer(this.requestParameters);
        TenpayUtil.addParameter(buf, "bank_type", this.payRequest.getBank_type());
        TenpayUtil.addParameter(buf, "purchaser_id", this.payRequest.getPurchaser_id());
        String encodeDesc = TenpayUtil.URLEncode2GBK(this.payRequest.getDesc());
        TenpayUtil.addParameter(buf, "desc", encodeDesc);
        TenpayUtil.addParameter(buf, "sign", this.sign);
        this.requestParameters = buf.toString();
    }
}

