/*
 * Decompiled with CFR 0.152.
 */
package tot.count;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import tot.count.CountBean;
import tot.count.CountCache;
import tot.db.DBUtils;

public class CountControl {
    private static long lastExecuteTime = 0L;
    private static long executeSep = 6000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeUpdate() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DBUtils.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement("update t_article set hits=hits+1 where id=?");
            for (int i = 0; i < CountCache.list.size(); ++i) {
                CountBean cb = (CountBean)CountCache.list.getFirst();
                CountCache.list.removeFirst();
                ps.setInt(1, cb.getCountId());
                ps.addBatch();
            }
            int[] counts = ps.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.clearParameters();
                    ps.close();
                    ps = null;
                }
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {}
            DBUtils.closeConnection(conn);
        }
    }

    public long getLast() {
        return lastExecuteTime;
    }

    public void run() {
        long now = System.currentTimeMillis();
        if (now - lastExecuteTime > executeSep) {
            lastExecuteTime = now;
            this.executeUpdate();
        }
    }
}

