/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class AdDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AdDaoImplJDBC.class);

    public int getLastId() {
        int returnValue = 0;
        String sql = null;
        DataField df = null;
        sql = "select id from t_ad order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAd(int id, int categoryid, String title, String content, int adtype, Timestamp expirestime, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_ad(id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime) values(?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, id);
                ps.setInt(2, categoryid);
                ps.setString(3, title);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(4, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(4, content);
                }
                ps.setInt(5, adtype);
                ps.setTimestamp(6, expirestime);
                ps.setTimestamp(7, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Ad error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modAd(int id, int categoryid, String title, String content, int adtype, Timestamp expirestime, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_ad set CategoryId=?,Title=?,Content=?,AdType=?,ExpiresTime=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, categoryid);
                ps.setString(2, title);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(3, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(3, content);
                }
                ps.setInt(4, adtype);
                ps.setTimestamp(5, expirestime);
                ps.setTimestamp(6, moditime);
                ps.setInt(7, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Ad error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delAd(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_ad where id=" + id);
    }

    public Collection getAds() {
        String sql = "select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad order by id asc";
        return this.getData(sql, "id,CategoryId,Title,AdType,ExpiresTime,ModiTime");
    }

    public Collection getAdList_Limit(int categoryid, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad");
            if (categoryid > 0) {
                sql.append(" where CategoryId=" + categoryid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,CategoryId,Title,AdType,ExpiresTime,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,CategoryId,Title,AdType,ExpiresTime,ModiTime FROM t_ad WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_ad");
            if (categoryid > 0) {
                sql.append(" where CategoryId=" + categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=" + categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,CategoryId,Title,AdType,ExpiresTime,ModiTime");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad");
        if (categoryid > 0) {
            sql.append(" where CategoryId=" + categoryid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), "id,CategoryId,Title,AdType,ExpiresTime,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getAd(int id) {
        return this.getFirstData("select id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime from t_ad where id=" + id, "id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime");
    }

    public int getTotalCount(int categoryid) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_ad");
        if (categoryid > 0) {
            sql.append(" where CategoryId=");
            sql.append(categoryid);
        }
        return this.getDataCount(sql.toString());
    }
}

