/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;
import tot.util.DateUtil;
import tot.util.MD5;

public class AdminDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AdminDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAdmin(String admin, String passwd, int roleid, Timestamp moditime) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_admin(UserName,PassWord,RoleId,ModiTime,IsLock,LoginNum) values(?,?,?,?,0,0)";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, roleid);
            ps.setTimestamp(4, moditime);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modAdmin(String admin, int roleid, int adminid) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_admin set UserName=?,RoleId=? where id=?";
        try {
            MD5 md5 = new MD5();
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setInt(2, roleid);
            ps.setInt(3, adminid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
            DBUtils.closePrepareStatement(ps);
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePass(String username, String passwd) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_admin set PassWord=? where UserName=?";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, passwd);
            ps.setString(2, username);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean deleAdmin(int adminid) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_admin where id=" + adminid);
    }

    public void updateLoginNum(String admin) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_admin set LoginNum=LoginNum+1 where UserName='" + admin + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adminLogin(String admin, String passwd) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = false;
        if (DateUtil.isExpire()) {
            throw new ObjectNotFoundException("System get error");
        }
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_admin where UserName=? and PassWord=? and IsLock=0");
            ps.setString(1, admin);
            ps.setString(2, password);
            rs = ps.executeQuery();
            if (rs.next()) {
                returnValue = true;
            }
            if (returnValue) {
                this.updateLoginNum(admin);
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.error((Object)"Sql Execution Error!", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getAdminStat(Timestamp startDate, Timestamp endDate, int offset, int rowsNum) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DataField> returnList = new ArrayList<DataField>();
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select t_admin.UserName,count(*) as c from t_article,t_admin where t_admin.UserName=t_article.UserName and t_article.ModiTime>? and t_article.ModiTime<? group by t_admin.UserName order by c desc", 1004, 1007);
            ps.setTimestamp(1, startDate);
            ps.setTimestamp(2, endDate);
            ps.setMaxRows(offset + rowsNum);
            try {
                ps.setFetchSize(rowsNum);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            rs = ps.executeQuery();
            boolean loop = rs.absolute(offset + 1);
            Object splitStr = null;
            while (loop) {
                DataField df = new DataField();
                df.setField("Title", rs.getString(1), 0);
                df.setField("Num", rs.getString(2), 0);
                returnList.add(df);
                if (returnList.size() >= rowsNum) break;
                loop = rs.next();
            }
        }
        catch (SQLException e) {
            DBUtils.closeResultSet(rs);
            DBUtils.resetStatement(ps);
            DBUtils.closeStatement(ps);
            DBUtils.closeConnection(conn);
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.resetStatement(ps);
                DBUtils.closeStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.resetStatement(ps);
        DBUtils.closeStatement(ps);
        DBUtils.closeConnection(conn);
        return returnList;
    }

    public Collection getAdminList(int roleid, int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,UserName,LoginNum,IsLock,RoleId,ModiTime,RoleId";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_admin WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_admin where 1=1");
            if (roleid > 0) {
                sql.append(" and RoleId=" + roleid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (roleid > 0) {
                sql.append(" and RoleId=" + roleid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_admin where 1=1");
            if (roleid > 0) {
                sql.append(" and RoleId=" + roleid);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_admin order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getAdmin(int id) {
        String fieldArr = "id,UserName,PassWord,LoginNum,IsLock,RoleId,ModiTime";
        String sql = "select " + fieldArr + " from t_admin where id=" + id;
        return this.getFirstData(sql, fieldArr);
    }

    public static boolean ifHasPrivilege(String privilege, String rolecode) {
        boolean returnValue = false;
        String[] privArr = null;
        if (privilege != null && rolecode != null) {
            privArr = privilege.split(",");
            for (int i = 0; i < privArr.length; ++i) {
                if (!privArr[i].equalsIgnoreCase(rolecode)) continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrivelege(String username) {
        String returnValue;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select t_role.Privilege from t_admin,t_role where t_admin.UserName=? and t_admin.RoleId=t_role.id");
                ps.setString(1, username);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnValue = rs.getString(1);
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"Sql Execution Error!", (Throwable)e);
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(String username) {
        String returnValue;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select id from t_admin where UserName=?");
                ps.setString(1, username);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnValue = rs.getString(1);
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"Sql Execution Error!", (Throwable)e);
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public void lockAdmin(String[] s) {
        this.bat("update t_admin set IsLock=1 where id=?", s);
    }

    public void unlockAdmin(String[] s) {
        this.bat("update t_admin set IsLock=0 where id=?", s);
    }

    public int getAdminNum(int roleid) {
        int returnValue = 0;
        String sql = "select count(*) from t_admin where 1=1";
        if (roleid > 0) {
            sql = sql + " and RoleId=" + roleid;
        }
        returnValue = this.getDataCount(sql);
        return returnValue;
    }
}

