/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class AgencyDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AgencyDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findIdByUserName(String username) {
        int returnValue = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_2agency where UserName=?");
            ps.setString(1, username);
            rs = ps.executeQuery();
            returnValue = rs.next() ? rs.getInt(1) : 0;
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findByUserId(String userid) {
        boolean returnValue = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select * from t_2agency where UserName=?");
            ps.setString(1, userid);
            rs = ps.executeQuery();
            returnValue = rs.next();
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAgency(String username, String password, String title, int cityid, String address, String tel, String fax, String contactman, String mobile, String email, String weburl, String master, String manager, String cercard, String cerno, String regmoney, String regtime, String hasman, String othershop, String servtype, String descri, Timestamp begintime, Timestamp endtime, int maxlimit, int usednum, int sortnum, String photo) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_2agency(UserName,PassWord,Title,CityId,Address,Tel,Fax,ContactMan,Mobile,Email,WebUrl,Master,Manager,CerCard,CerNo,RegMoney,RegTime,HasMan,OtherShop,ServType,Descri,BeginTime,EndTime,MaxLimit,UsedNum,SortNum,Photo) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, username);
                ps.setString(2, password);
                ps.setString(3, title);
                ps.setInt(4, cityid);
                ps.setString(5, address);
                ps.setString(6, tel);
                ps.setString(7, fax);
                ps.setString(8, contactman);
                ps.setString(9, mobile);
                ps.setString(10, email);
                ps.setString(11, weburl);
                ps.setString(12, master);
                ps.setString(13, manager);
                ps.setString(14, cercard);
                ps.setString(15, cerno);
                ps.setString(16, regmoney);
                ps.setString(17, regtime);
                ps.setString(18, hasman);
                ps.setString(19, othershop);
                ps.setString(20, servtype);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(21, (Reader)new StringReader(descri), descri.length());
                } else {
                    ps.setString(21, descri);
                }
                ps.setTimestamp(22, begintime);
                ps.setTimestamp(23, endtime);
                ps.setInt(24, maxlimit);
                ps.setInt(25, usednum);
                ps.setInt(26, sortnum);
                ps.setString(27, photo);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Agency error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modAgency(int id, String username, String password, String title, int cityid, String address, String tel, String fax, String contactman, String mobile, String email, String weburl, String master, String manager, String cercard, String cerno, String regmoney, String regtime, String hasman, String othershop, String servtype, String descri, Timestamp begintime, Timestamp endtime, int maxlimit, int usednum, int sortnum, String photo) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_2agency set UserName=?,PassWord=?,Title=?,CityId=?,Address=?,Tel=?,Fax=?,ContactMan=?,Mobile=?,Email=?,WebUrl=?,Master=?,Manager=?,CerCard=?,CerNo=?,RegMoney=?,RegTime=?,HasMan=?,OtherShop=?,ServType=?,Descri=?,BeginTime=?,EndTime=?,MaxLimit=?,UsedNum=?,SortNum=?,Photo=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, username);
                ps.setString(2, password);
                ps.setString(3, title);
                ps.setInt(4, cityid);
                ps.setString(5, address);
                ps.setString(6, tel);
                ps.setString(7, fax);
                ps.setString(8, contactman);
                ps.setString(9, mobile);
                ps.setString(10, email);
                ps.setString(11, weburl);
                ps.setString(12, master);
                ps.setString(13, manager);
                ps.setString(14, cercard);
                ps.setString(15, cerno);
                ps.setString(16, regmoney);
                ps.setString(17, regtime);
                ps.setString(18, hasman);
                ps.setString(19, othershop);
                ps.setString(20, servtype);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(21, (Reader)new StringReader(descri), descri.length());
                } else {
                    ps.setString(21, descri);
                }
                ps.setTimestamp(22, begintime);
                ps.setTimestamp(23, endtime);
                ps.setInt(24, maxlimit);
                ps.setInt(25, usednum);
                ps.setInt(26, sortnum);
                ps.setString(27, photo);
                ps.setInt(28, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Agency error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delAgency(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_2agency where id=" + id);
    }

    public DataField getAgency(int id) {
        String fields = "UserName,PassWord,Title,CityId,Address,Tel,Fax,ContactMan,Mobile,Email,WebUrl,Master,Manager,CerCard,CerNo,RegMoney,RegTime,HasMan,OtherShop,ServType,Descri,BeginTime,EndTime,MaxLimit,UsedNum,SortNum,Photo";
        return this.getFirstData("select " + fields + " from t_2agency where id=" + id, fields);
    }

    public int getTotalCount(int check) {
        String sql = "select count(*) from t_2agency";
        sql = sql + " where IsOk=" + check;
        return this.getDataCount(sql);
    }

    public Collection getAgencyList(int check, int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,UserName,PassWord,Title,Address,Tel,BeginTime,EndTime,MaxLimit,UsedNum,IsOk,SortNum,Photo";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_2agency WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_2agency");
            sql.append(" where IsOk=").append(check);
            sql.append("ORDER BY id DESC) AS t))");
            sql.append(" and IsOk=").append(check);
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_2agency");
            sql.append(" where IsOk=").append(check);
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_2agency");
        sql.append(" where IsOk=").append(check);
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getAgencys() {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,Title,Address,Tel,Photo";
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_2agency where IsOk=1 order by SortNum asc");
        return this.getData(sql.toString(), fieldArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(int currentid) {
        StringBuffer sb = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select id,Title from t_2agency where IsOk=1 order by id asc");
            while (rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if (currentid == rs.getInt(1)) {
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean agencyLogin(String userid, String passwd) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = false;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select EndTime from t_2agency where UserName=? and PassWord=? and IsOk=1");
            ps.setString(1, userid);
            ps.setString(2, passwd);
            rs = ps.executeQuery();
            if (rs.next()) {
                long endt = rs.getTimestamp(1).getTime();
                returnValue = System.currentTimeMillis() <= endt;
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            log.error((Object)"Sql Execution Error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reachMaxLimit(int id) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = true;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select MaxLimit,UsedNum from t_2agency where id=?");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                int maxlimit = rs.getInt(1);
                int usednum = rs.getInt(2);
                returnValue = usednum >= maxlimit;
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            log.error((Object)"Sql Execution Error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public void batDel(String[] s) {
        this.bat("delete from t_2agency where id=?", s);
    }

    public void batCheck(String[] s) {
        this.bat("update t_2agency set IsOk=1 where id=?", s);
    }

    public void batUnCheck(String[] s) {
        this.bat("update t_2agency set IsOk=0 where id=?", s);
    }

    public void updateUsedNum(int id) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_2agency set UsedNum=UsedNum+1 where id=" + id);
    }

    public void minusUsedNum(int id) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_2agency set UsedNum=UsedNum-1 where id=" + id);
    }
}

