/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class AreaDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AreaDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addArea(String title, int cityid) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_area(Title,CityId) values(?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setInt(2, cityid);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add area error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modArea(int id, String title, int cityid) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_area set Title=?,CityId=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setInt(2, cityid);
                ps.setInt(3, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod area error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delArea(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_area where id=" + id);
    }

    public DataField getArea(int id) {
        return this.getFirstData("select id,Title,CityId from t_area where id=" + id, "id,Title,CityId");
    }

    public int getTotalCount(int cityid) {
        String sql = "select count(*) from t_area";
        if (cityid != 0) {
            sql = sql + " where CityId=" + cityid;
        }
        return this.getDataCount(sql);
    }

    public Collection getAreaListNoLimit() {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,Title,CityId";
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_area order by id asc");
        return this.getData(sql.toString(), fieldArr);
    }

    public Collection getAreaList(int cityid, int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,Title";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_area WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_area");
            if (cityid != 0) {
                sql.append(" where CityId=").append(cityid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (cityid != 0) {
                sql.append(" and CityId=").append(cityid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_area");
            if (cityid != 0) {
                sql.append(" where CityId=").append(cityid);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_area");
        if (cityid != 0) {
            sql.append(" where CityId=").append(cityid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(int currentid) {
        StringBuffer sb = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select id,Title from t_area order by id asc");
            while (rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if (currentid == rs.getInt(1)) {
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    public void batDel(String[] s) {
        this.bat("delete from t_area where id=?", s);
    }
}

