/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;
import tot.global.Sysconfig;
import tot.search.SearchQueryNoSql;
import tot.util.DateUtil;
import tot.util.FileUtil;
import tot.util.StringUtils;

public class ArticleDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(ArticleDaoImplJDBC.class);

    public int getLastId() {
        int returnValue = 0;
        String sql = null;
        DataField df = null;
        if (DBUtils.getDatabaseType() == 11) {
            sql = "select top 1 id from t_article order by id desc";
        } else if (DBUtils.getDatabaseType() == 15) {
            sql = "select id from t_article order by id desc limit 0,1";
        } else if (DBUtils.getDatabaseType() == 12) {
            sql = "select id from t_article order by id desc fetch first 1 rows only";
        } else if (DBUtils.getDatabaseType() == 10) {
            sql = "select id from t_article where rownum=1 order by id desc";
        }
        df = this.getFirstData(sql, "id");
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    public int getLastId2() {
        int returnValue = 0;
        String sql = null;
        DataField df = null;
        sql = "select id from t_article order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHits(int id) {
        int returnValue;
        block5: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = 0;
            String sql = null;
            sql = "select Hits from t_article where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, id);
                rs = ps.executeQuery();
                returnValue = rs.next() ? rs.getInt(1) : 0;
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"get hits error", (Throwable)e);
                break block5;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addArticle(String title, String subHeading, String titleColor, String keyWords, String relateKey, int relateNum, String content, int isOutLink, String outLinkUrl, int parentId, int categoryId, int templateId, int specialId, int top1, int toTop, int toHot, int recommend, int images, int checked, String author, String sourceFrom, String editor, String userName, String photo, int hits, String savePath, Timestamp moditime, int isslide, String summary) {
        boolean returnValue;
        block11: {
            Connection conn = null;
            PreparedStatement ps = null;
            returnValue = true;
            String sql = "insert into t_article(Title,SubHeading,TitleColor,KeyWords,RelateKey,RelateNum,Content,IsOutLink,OutLinkUrl,ParentId,CategoryId,TemplateId,SpecialId,Top1,ToTop,ToHot,Recommend,Images,Checked,Author,SourceFrom,Editor,UserName,Photo,Hits,SavePath,ModiTime,IsSlide,Summary,SortId,ModDate) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, subHeading);
                ps.setString(3, titleColor);
                ps.setString(4, keyWords);
                ps.setString(5, relateKey);
                ps.setInt(6, relateNum);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(7, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(7, content);
                }
                ps.setInt(8, isOutLink);
                ps.setString(9, outLinkUrl);
                ps.setInt(10, parentId);
                ps.setInt(11, categoryId);
                ps.setInt(12, templateId);
                ps.setInt(13, specialId);
                ps.setInt(14, top1);
                ps.setInt(15, toTop);
                ps.setInt(16, toHot);
                ps.setInt(17, recommend);
                ps.setInt(18, images);
                ps.setInt(19, checked);
                ps.setString(20, author);
                ps.setString(21, sourceFrom);
                ps.setString(22, editor);
                ps.setString(23, userName);
                ps.setString(24, photo);
                ps.setInt(25, hits);
                ps.setString(26, savePath);
                ps.setTimestamp(27, moditime);
                ps.setInt(28, isslide);
                ps.setString(29, summary);
                ps.setInt(30, this.getLastId());
                ps.setString(31, DateUtil.getStringDate());
                if (ps.executeUpdate() != 1) {
                    returnValue = false;
                }
                conn.commit();
                conn.setAutoCommit(true);
                DBUtils.closePrepareStatement(ps);
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                        conn.setAutoCommit(true);
                        log.error((Object)"add Article error", (Throwable)e);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                break block11;
            }
            finally {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modArticle(int id, String title, String subHeading, String titleColor, String keyWords, String relateKey, int relateNum, String content, int isOutLink, String outLinkUrl, int parentId, int categoryId, int templateId, int specialId, int top1, int toTop, int toHot, int recommend, int images, int checked, String author, String sourceFrom, String editor, String userName, String photo, int hits, String savePath, Timestamp moditime, int isslide, String summary, int sortid, String moddate) {
        boolean returnValue;
        block11: {
            Connection conn = null;
            PreparedStatement ps = null;
            returnValue = true;
            String sql = "update t_article set Title=?,SubHeading=?,TitleColor=?,KeyWords=?,RelateKey=?,RelateNum=?,Content=?,IsOutLink=?,OutLinkUrl=?,ParentId=?,CategoryId=?,TemplateId=?,SpecialId=?,Top1=?,ToTop=?,ToHot=?,Recommend=?,Images=?,Checked=?,Author=?,SourceFrom=?,Editor=?,UserName=?,Photo=?,Hits=?,SavePath=?,IsSlide=?,Summary=?,SortId=?,ModDate=? where id=?";
            try {
                conn = DBUtils.getConnection();
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, subHeading);
                ps.setString(3, titleColor);
                ps.setString(4, keyWords);
                ps.setString(5, relateKey);
                ps.setInt(6, relateNum);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(7, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(7, content);
                }
                ps.setInt(8, isOutLink);
                ps.setString(9, outLinkUrl);
                ps.setInt(10, parentId);
                ps.setInt(11, categoryId);
                ps.setInt(12, templateId);
                ps.setInt(13, specialId);
                ps.setInt(14, top1);
                ps.setInt(15, toTop);
                ps.setInt(16, toHot);
                ps.setInt(17, recommend);
                ps.setInt(18, images);
                ps.setInt(19, checked);
                ps.setString(20, author);
                ps.setString(21, sourceFrom);
                ps.setString(22, editor);
                ps.setString(23, userName);
                ps.setString(24, photo);
                ps.setInt(25, hits);
                ps.setString(26, savePath);
                ps.setInt(27, isslide);
                ps.setString(28, summary);
                ps.setInt(29, sortid);
                ps.setString(30, moddate);
                ps.setInt(31, id);
                if (ps.executeUpdate() != 1) {
                    returnValue = false;
                }
                conn.commit();
                conn.setAutoCommit(true);
                DBUtils.closePrepareStatement(ps);
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                        conn.setAutoCommit(true);
                        log.error((Object)"add Article error", (Throwable)e);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                break block11;
            }
            finally {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public void sendToRecycle(String[] s) {
        this.bat("update t_article set Checked=2 where id=?", s);
    }

    public void resumes(String[] s) {
        this.bat("update t_article set Checked=1 where id=?", s);
    }

    public boolean moveToRecycle(int id) throws ObjectNotFoundException, DatabaseException {
        boolean ret = true;
        ret = this.exe("update t_article set Checked=2 where id=" + id);
        return ret;
    }

    public boolean delArticle(int id, String path) throws ObjectNotFoundException, DatabaseException {
        boolean ret = true;
        String filepath = null;
        DataField article = this.getArticle(id);
        if (article != null) {
            int outlink = Integer.parseInt(article.getFieldValue("IsOutLink"));
            if (outlink == 0) {
                filepath = article.getFieldValue("SavePath");
                String diagonal = FileUtil.getSeparator();
                filepath = StringUtils.replaceString(filepath, "/", diagonal);
                filepath = filepath.substring(1, filepath.length());
                filepath = path + filepath;
                try {
                    FileUtil.deleteFile(filepath);
                }
                catch (IOException e) {
                    log.info((Object)("delete file " + filepath + " failed."));
                }
            }
            log.info((Object)("delete file " + filepath));
        }
        ret = this.exe("delete from t_article where id=" + id);
        return ret;
    }

    public DataField getArticle(int id) {
        String fieldArr = "id,Title,SubHeading,TitleColor,KeyWords,RelateKey,RelateNum,Content,IsOutLink,OutLinkUrl,ParentId,CategoryId,TemplateId,SpecialId,Top1,ToTop,ToHot,Recommend,Images,IsSlide,Checked,Author,SourceFrom,Editor,UserName,Photo,Hits,SavePath,ModiTime,Summary,SortId,ModDate";
        String sql = "select " + fieldArr + " from t_article where id=" + id;
        return this.getFirstData(sql, fieldArr);
    }

    public DataField getArticleSimple(int id) {
        String fieldArr = "id,Title,CategoryId,Hits,SavePath,ModiTime";
        String sql = "select " + fieldArr + " from t_article where id=" + id;
        return this.getFirstData(sql, fieldArr);
    }

    public void batCheck(String[] s) {
        this.bat("update t_article set Checked=1 where id=?", s);
    }

    public void batUncheck(String[] s) {
        this.bat("update t_article set Checked=0 where id=?", s);
    }

    public void batRecommend(String[] s) {
        this.bat("update t_article set Recommend=1 where id=?", s);
    }

    public void batUnrecommend(String[] s) {
        this.bat("update t_article set Recommend=0 where id=?", s);
    }

    public void batDelete(String[] s) {
        this.bat("update t_article set Checked=2 where id=?", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArticle(String[] s, int tocategoryid) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnInt = false;
        int ParentId = DaoFactory.getCategoryDAO().getParentId(tocategoryid);
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("update t_article set CategoryId=?,ParentId=? where id=?");
            for (int i = 0; i < s.length; ++i) {
                int f = Integer.parseInt(s[i]);
                ps.setInt(1, tocategoryid);
                ps.setInt(2, ParentId);
                ps.setInt(3, f);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
    }

    public Collection getArticleIndex_Limit(int categoryid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where IsOutLink=0");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where IsOutLink=0");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" and IsOutLink=0 ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where IsOutLink=0");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleList_Limit(int categoryid, int specialid, int slide, int checked, int top1, int totop, int hot, int images, int rem, int currentpage, int pagesize) {
        String fieldArr = "id,Title,Summary,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModDate";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=").append(categoryid);
            }
            if (specialid > 0) {
                sql.append(" and SpecialId=").append(specialid);
            }
            if (slide > 0) {
                sql.append(" and IsSlide=").append(slide);
            }
            if (checked > 0) {
                sql.append(" and Checked=").append(checked);
            }
            if (top1 > 0) {
                sql.append(" and Top1=").append(top1);
            }
            if (totop > 0) {
                sql.append(" and ToTop=").append(totop);
            }
            if (hot > 0) {
                sql.append(" and ToHot=").append(hot);
            }
            if (images > 0) {
                sql.append(" and Images=").append(images);
            }
            if (rem > 0) {
                sql.append(" and Recommend=").append(rem);
            }
            sql.append(" order by SortId desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=").append(categoryid);
            }
            if (specialid > 0) {
                sql.append(" and SpecialId=").append(specialid);
            }
            if (slide > 0) {
                sql.append(" and IsSlide=").append(slide);
            }
            if (checked > 0) {
                sql.append(" and Checked=").append(checked);
            }
            if (top1 > 0) {
                sql.append(" and Top1=").append(top1);
            }
            if (totop > 0) {
                sql.append(" and ToTop=").append(totop);
            }
            if (hot > 0) {
                sql.append(" and ToHot=").append(hot);
            }
            if (images > 0) {
                sql.append(" and Images=").append(images);
            }
            if (rem > 0) {
                sql.append(" and Recommend=").append(rem);
            }
            sql.append(" ORDER BY id DESC,SortId DESC) AS t)) and 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=").append(categoryid);
            }
            if (specialid > 0) {
                sql.append(" and SpecialId=").append(specialid);
            }
            if (slide > 0) {
                sql.append(" and IsSlide=").append(slide);
            }
            if (checked > 0) {
                sql.append(" and Checked=").append(checked);
            }
            if (top1 > 0) {
                sql.append(" and Top1=").append(top1);
            }
            if (totop > 0) {
                sql.append(" and ToTop=").append(totop);
            }
            if (hot > 0) {
                sql.append(" and ToHot=").append(hot);
            }
            if (images > 0) {
                sql.append(" and Images=").append(images);
            }
            if (rem > 0) {
                sql.append(" and Recommend=").append(rem);
            }
            sql.append(" ORDER BY id DESC,SortId DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=").append(categoryid);
        }
        if (specialid > 0) {
            sql.append(" and SpecialId=").append(specialid);
        }
        if (slide > 0) {
            sql.append(" and IsSlide=").append(slide);
        }
        if (checked > 0) {
            sql.append(" and Checked=").append(checked);
        }
        if (top1 > 0) {
            sql.append(" and Top1=").append(top1);
        }
        if (totop > 0) {
            sql.append(" and ToTop=").append(totop);
        }
        if (hot > 0) {
            sql.append(" and ToHot=").append(hot);
        }
        if (images > 0) {
            sql.append(" and Images=").append(images);
        }
        if (rem > 0) {
            sql.append(" and Recommend=").append(rem);
        }
        sql.append(" order by SortId desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleHits_Limit(int dateset, int currentpage, int pagesize) {
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where IsOutLink=0");
            if (dateset > 0) {
                sql.append(" and to_days(now())-to_days(ModiTime)<");
                sql.append(dateset);
            }
            sql.append(" order by Hits desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (Hits <=(SELECT MIN(Hits) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" Hits  FROM t_article where IsOutLink=0");
            if (dateset > 0) {
                sql.append(" and DATEDIFF(d,ModiTime,GETDATE())<");
                sql.append(dateset);
            }
            sql.append(" ORDER BY Hits DESC) AS t))");
            if (dateset > 0) {
                sql.append(" and DATEDIFF(d,ModiTime,GETDATE())<");
                sql.append(dateset);
            }
            sql.append(" and IsOutLink=0 ORDER BY Hits DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where IsOutLink=0");
        if (dateset > 0) {
            // empty if block
        }
        sql.append(" order by Hits desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleList_Limit(int categoryid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,Summary,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModDate";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by SortId desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Summary,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC,SortId DESC) AS t)) and Checked=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC,SortId DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        sql.append(" order by SortId desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleListBySpecial_Limit(int specialid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" ORDER BY id DESC) AS t)) and Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked=1");
        if (specialid > 0) {
            sql.append(" and SpecialId=");
            sql.append(specialid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getSlideArticleList_Limit(int categoryid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked=1 and IsSlide=1");
            if (categoryid > 0) {
                sql.append(" and (ParentId=").append(categoryid).append(" or CategoryId=").append(categoryid).append(")");
            }
            sql.append(" order by SortId desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked=1 and IsSlide=1");
            if (categoryid > 0) {
                sql.append(" and (ParentId=").append(categoryid).append(" or CategoryId=").append(categoryid).append(")");
            }
            sql.append(" ORDER BY SortId desc,id DESC) AS t)) and Checked=1 and IsSlide=1");
            if (categoryid > 0) {
                sql.append(" and (ParentId=").append(categoryid).append(" or CategoryId=").append(categoryid).append(")");
            }
            sql.append(" ORDER BY SortId desc,id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked=1 and IsSlide=1");
        if (categoryid > 0) {
            sql.append(" and (ParentId=").append(categoryid).append(" or CategoryId=").append(categoryid).append(")");
        }
        sql.append(" order by SortId desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleSpecialList_Limit(int specialid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" ORDER BY id DESC) AS t)) and Checked=1");
            if (specialid > 0) {
                sql.append(" and SpecialId=");
                sql.append(specialid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked=1");
        if (specialid > 0) {
            sql.append(" and SpecialId=");
            sql.append(specialid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleDeleteList_Limit(int categoryid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked=2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked=2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t)) and Checked=2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked=2");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getArticleAuditingList_Limit(int status, int categoryid, int currentpage, int pagesize) {
        String fieldArr = "id,Title,IsOutLink,OutLinkUrl,CategoryId,Checked,Photo,SavePath,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fieldArr + " from t_article where Checked<>2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (status == 1) {
                sql.append(" and Checked=1");
            } else if (status == 2) {
                sql.append(" and Checked=0");
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fieldArr + " FROM t_article WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_article where Checked<>2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (status == 1) {
                sql.append(" and Checked=1");
            } else if (status == 2) {
                sql.append(" and Checked=0");
            }
            sql.append(" ORDER BY id DESC) AS t)) and Checked<>2");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (status == 1) {
                sql.append(" and Checked=1");
            } else if (status == 2) {
                sql.append(" and Checked=0");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldArr + " from t_article where Checked<>2");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        if (status == 1) {
            sql.append(" and Checked=1");
        } else if (status == 2) {
            sql.append(" and Checked=0");
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(int categoryid, int specialid, int slide, int checked, int top1, int totop, int hot, int images, int rem) {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) from t_article where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=").append(categoryid);
        }
        if (specialid > 0) {
            sql.append(" and SpecialId=").append(specialid);
        }
        if (slide > 0) {
            sql.append(" and IsSlide=").append(slide);
        }
        if (checked > 0) {
            sql.append(" and Checked=").append(checked);
        }
        if (top1 > 0) {
            sql.append(" and Top1=").append(top1);
        }
        if (totop > 0) {
            sql.append(" and ToTop=").append(totop);
        }
        if (hot > 0) {
            sql.append(" and ToHot=").append(hot);
        }
        if (images > 0) {
            sql.append(" and Images=").append(images);
        }
        if (rem > 0) {
            sql.append(" and Recommend=").append(rem);
        }
        return this.getDataCount(sql.toString());
    }

    public int getTotalCount(int categoryid) {
        String sql = "select count(*) from t_article";
        if (categoryid > 0) {
            sql = sql + " where CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public int getCheckedTotalCount(int categoryid) {
        String sql = "select count(*) from t_article where Checked=1";
        if (categoryid > 0) {
            sql = sql + " and CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public int getNoCheckedTotalCount(int categoryid) {
        String sql = "select count(*) from t_article where Checked=0";
        if (categoryid > 0) {
            sql = sql + " and CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public int getTotalCount_Special(int specialid) {
        String sql = "select count(*) from t_article";
        if (specialid > 0) {
            sql = sql + " where SpecialId=" + specialid;
        }
        return this.getDataCount(sql);
    }

    public int getTotalCount_Slide(int categoryid) {
        String sql = "select count(*) from t_article where IsSlide=1";
        if (categoryid > 0) {
            sql = sql + " and CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public int getTotalCount_delete(int categoryid) {
        String sql = "select count(*) from t_article where Checked=2";
        if (categoryid > 0) {
            sql = sql + " and CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public int getTotalCount_Date(int dateset) {
        String sql = "select count(*) from t_article where IsOutLink=0";
        if (dateset > 0) {
            if (DBUtils.getDatabaseType() == 15) {
                sql = sql + " and to_days(now())-to_days(ModiTime)<" + dateset;
            } else if (DBUtils.getDatabaseType() == 11) {
                sql = sql + " and DATEDIFF(d,ModiTime,GETDATE())<" + dateset;
            }
        }
        return this.getDataCount(sql);
    }

    public String get1Title(int categoryId, String sort, String ArticleAttr, int charMax, String linkStyle) {
        String ret = "";
        StringBuffer sql = new StringBuffer(512);
        DataField df = null;
        sql.append("select id,Title,SavePath,IsOutLink,OutLinkUrl from t_article where Checked=1");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and CategoryId=" + categoryId);
        }
        sql.append(" order by " + sort + " desc");
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        Collection lists = this.getDataList_Limit_Normal(sql.toString(), "id,Title,SavePath,IsOutLink,OutLinkUrl", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        if (df != null) {
            String tlinkurl = "";
            tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
            ret = "<a href=\"" + tlinkurl + "\" class=\"" + linkStyle + "\" target=\"_blank\">" + StringUtils.getTopic(df.getFieldValue("Title"), charMax) + "</a>";
        }
        return ret;
    }

    public String get1Content(int categoryId, String sort, String ArticleAttr, int charMax, String linkStyle) {
        String ret = "";
        StringBuffer sql = new StringBuffer(512);
        DataField df = null;
        sql.append("select id,Summary,SavePath,IsOutLink,OutLinkUrl from t_article where Checked=1");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and CategoryId=" + categoryId);
        }
        sql.append(" order by " + sort + " desc");
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        Collection lists = this.getDataList_Limit_Normal(sql.toString(), "id,Summary,SavePath,IsOutLink,OutLinkUrl", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext() && (df = (DataField)iter.next()) != null) {
            String tlinkurl = "";
            tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
            String artCont = df.getFieldValue("Summary");
            ret = "<a href=\"" + tlinkurl + "\" class=\"" + linkStyle + "\" target=\"_blank\">" + StringUtils.getTopic(artCont, charMax) + "</a>";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArticles(int categoryId, String tableWidth, String tableStyle, int lineHeight, int rowsNum, int colsNum, String sort, int charMax, String titlePrefix, int showTime, int getChilds, int showCatalog, String ArticleAttr) {
        int retNum = rowsNum * colsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" a.Title AS atitle,a.IsOutLink,OutLinkUrl,a.SavePath AS asavepath,a.ModiTime,a.TitleColor,c.Title AS ctitle,c.SavePath AS csavepath,c.IsChannel from t_article AS a,t_category AS c where a.Checked=1 and a.CategoryId=c.id");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and a.Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and a.Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and a.ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and a.Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and a.ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and (a.CategoryId=" + categoryId);
            if (getChilds == 1) {
                sql.append(" or a.ParentId=" + categoryId);
            }
            sql.append(")");
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by a." + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        sb.append("<table width=\"");
        sb.append(tableWidth);
        sb.append("\" class=\"" + tableStyle + "\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get article:" + sql.toString()));
            for (int rows = 0; rows < rowsNum; ++rows) {
                sb.append("<tr>\n");
                for (int cols = 0; cols < colsNum && rs.next(); ++cols) {
                    sb.append("<td height=\"" + lineHeight + "\">\n");
                    sb.append("<div align=\"left\">");
                    if (showCatalog == 1) {
                        int isChannel = rs.getInt(9);
                        sb.append("<a href=\"");
                        sb.append(url + contextPath + rs.getString(8));
                        if (isChannel == 0) {
                            sb.append("/index_1.htm");
                        }
                        sb.append("\" target=\"_blank\">[");
                        sb.append(rs.getString(7));
                        sb.append("]</a>\n");
                    }
                    sb.append(titlePrefix);
                    sb.append("<a href=\"");
                    if (rs.getInt(2) == 0) {
                        sb.append(url + contextPath + rs.getString(4));
                    } else {
                        sb.append(rs.getString(3));
                    }
                    sb.append("\" target=\"_blank\">");
                    if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                        sb.append("<font color=\"");
                        sb.append(rs.getString(6));
                        sb.append("\">");
                    }
                    sb.append(StringUtils.getTopic(rs.getString(1), charMax));
                    if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                        sb.append("</font>");
                    }
                    sb.append("</a></div></td>\n");
                    if (showTime != 1) continue;
                    sb.append("<td width=\"10%\"><div align=\"center\">");
                    sb.append(rs.getString(5).substring(5, 10));
                    sb.append("</div></td>");
                }
                sb.append("</tr>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        sb.append("</table>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArticlesDiv(int categoryId, int rowsNum, String sort, int charMax, String titlePrefix, int showTime, int getChilds, int showCatalog, String ArticleAttr) {
        int retNum = rowsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" a.Title AS atitle,a.IsOutLink,OutLinkUrl,a.SavePath AS asavepath,a.ModiTime,a.TitleColor,c.Title AS ctitle,c.SavePath AS csavepath,c.IsChannel from t_article AS a,t_category AS c where a.Checked=1 and a.CategoryId=c.id");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and a.Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and a.Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and a.ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and a.Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and a.ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and (a.CategoryId=" + categoryId);
            if (getChilds == 1) {
                sql.append(" or a.ParentId=" + categoryId);
            }
            sql.append(")");
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by a." + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get articlediv:" + sql.toString()));
            for (int rows = 0; rows < rowsNum && rs.next(); ++rows) {
                sb.append("<li>\n");
                if (showTime == 1) {
                    sb.append("<span class=\"col_right\">");
                    sb.append(rs.getString(5).substring(5, 10));
                    sb.append("</span>");
                }
                if (showCatalog == 1) {
                    int isChannel = rs.getInt(9);
                    sb.append("<a href=\"");
                    sb.append(url + contextPath + rs.getString(8));
                    if (isChannel == 0) {
                        sb.append("/index_1.htm");
                    }
                    sb.append("\"  target=\"_blank\">[");
                    sb.append(rs.getString(7));
                    sb.append("]</a>\n");
                }
                sb.append(titlePrefix);
                sb.append("<a href=\"");
                if (rs.getInt(2) == 0) {
                    sb.append(url + contextPath + rs.getString(4));
                } else {
                    sb.append(rs.getString(3));
                }
                sb.append("\" title=\"" + rs.getString(1) + "\" target=\"_blank\">");
                if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                    sb.append("<font color=\"");
                    sb.append(rs.getString(6));
                    sb.append("\">");
                }
                sb.append(StringUtils.getTopic(rs.getString(1), charMax));
                if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                    sb.append("</font>");
                }
                sb.append("</a></li>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpecialArticles(int specialId, String tableWidth, String tableStyle, int lineHeight, int rowsNum, int colsNum, String sort, int charMax, String titlePrefix, int showTime, int showSpecial, String ArticleAttr) {
        int retNum = rowsNum * colsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" a.Title AS atitle,a.IsOutLink,OutLinkUrl,a.SavePath AS asavepath,a.ModiTime,a.TitleColor,c.Title AS ctitle,c.SavePath AS csavepath from t_article AS a,t_special AS c where a.Checked=1 and a.SpecialId=c.id");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and a.Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and a.Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and a.ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and a.Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and a.ToTop=1");
        }
        if (specialId > 0) {
            sql.append(" and a.SpecialId=" + specialId);
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by a." + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        sb.append("<table width=\"");
        sb.append(tableWidth);
        sb.append("\" class=\"" + tableStyle + "\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get special article:" + sql.toString()));
            for (int rows = 0; rows < rowsNum; ++rows) {
                sb.append("<tr>\n");
                for (int cols = 0; cols < colsNum && rs.next(); ++cols) {
                    sb.append("<td height=\"" + lineHeight + "\">\n");
                    sb.append("<div align=\"left\">");
                    if (showSpecial == 1) {
                        sb.append("<a href=\"");
                        sb.append(url + contextPath + rs.getString(8));
                        sb.append("/index_1.htm");
                        sb.append("\" target=\"_blank\">[");
                        sb.append(rs.getString(7));
                        sb.append("]</a>\n");
                    }
                    sb.append(titlePrefix);
                    sb.append("<a href=\"");
                    if (rs.getInt(2) == 0) {
                        sb.append(url + contextPath + rs.getString(4));
                    } else {
                        sb.append(rs.getString(3));
                    }
                    sb.append("\" target=\"_blank\">");
                    if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                        sb.append("<font color=\"");
                        sb.append(rs.getString(6));
                        sb.append("\">");
                    }
                    sb.append(StringUtils.getTopic(rs.getString(1), charMax));
                    if (rs.getString(6) != null && !rs.getString(6).equals("")) {
                        sb.append("</font>");
                    }
                    sb.append("</a></div></td>\n");
                    if (showTime != 1) continue;
                    sb.append("<td width=\"10%\"><div align=\"center\">");
                    sb.append(rs.getString(5).substring(5, 10));
                    sb.append("</div></td>");
                }
                sb.append("</tr>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        sb.append("</table>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgs(int categoryId, String tableWidth, String tableStyle, int rowsNum, int colsNum, String sort, int charMax, String titlePrefix, int ImgW, int ImgH, int getChilds, int showBorder, String ArticleAttr) {
        int retNum = rowsNum * colsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" Title,IsOutLink,OutLinkUrl,SavePath,TitleColor,Photo from t_article where Checked=1");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and (CategoryId=" + categoryId);
            if (getChilds == 1) {
                sql.append(" or ParentId=" + categoryId);
            }
            sql.append(")");
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by " + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        sb.append("<table width=\"");
        sb.append(tableWidth);
        sb.append("\" class=\"" + tableStyle + "\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get article:" + sql.toString()));
            for (int rows = 0; rows < rowsNum; ++rows) {
                sb.append("<tr>\n");
                for (int cols = 0; cols < colsNum && rs.next(); ++cols) {
                    String linkurl = "";
                    linkurl = rs.getInt(2) == 0 ? url + contextPath + rs.getString(4) : rs.getString(3);
                    sb.append("<td>\n");
                    sb.append("<div align=\"center\">");
                    sb.append("<a href=\"");
                    sb.append(linkurl);
                    sb.append("\" target=\"_blank\">");
                    sb.append("<img src=\"");
                    sb.append(rs.getString(6));
                    sb.append("\" border=\"0\"");
                    if (showBorder == 1) {
                        sb.append(" style=\"border:1px solid #000000;\"");
                    }
                    sb.append(" width=\"" + ImgW + "\"");
                    sb.append(" height=\"" + ImgH + "\"");
                    sb.append(" /></a>");
                    sb.append("<p style=\"margin:2px 0 2px 0;\"></p>");
                    sb.append(titlePrefix);
                    sb.append("<a href=\"");
                    sb.append(linkurl);
                    sb.append("\" target=\"_blank\">");
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("<font color=\"");
                        sb.append(rs.getString(5));
                        sb.append("\">");
                    }
                    sb.append(StringUtils.getTopic(rs.getString(1), charMax));
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("</font>");
                    }
                    sb.append("</a></div></td>\n");
                }
                sb.append("</tr>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        sb.append("</table>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgsDiv(int categoryId, int rowsNum, int showTitle, String sort, int charMax, String titlePrefix, int ImgW, int ImgH, int getChilds, int showBorder, String ArticleAttr) {
        int retNum = rowsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" Title,IsOutLink,OutLinkUrl,SavePath,TitleColor,Photo from t_article where Checked=1");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and (CategoryId=" + categoryId);
            if (getChilds == 1) {
                sql.append(" or ParentId=" + categoryId);
            }
            sql.append(")");
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by " + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get imgs div:" + sql.toString()));
            for (int rows = 0; rows < rowsNum && rs.next(); ++rows) {
                String linkurl = "";
                linkurl = rs.getInt(2) == 0 ? url + contextPath + rs.getString(4) : rs.getString(3);
                sb.append("<li>\n");
                sb.append("<a href=\"");
                sb.append(linkurl);
                sb.append("\" target=\"_blank\">");
                sb.append("<img src=\"");
                sb.append(rs.getString(6));
                sb.append("\" border=\"0\"");
                if (showBorder == 1) {
                    sb.append(" style=\"border:1px solid #000000;\"");
                }
                sb.append(" width=\"" + ImgW + "\"");
                sb.append(" height=\"" + ImgH + "\"");
                sb.append(" alt=\"" + rs.getString(1) + "\"");
                sb.append(" /></a>");
                if (showTitle == 1) {
                    sb.append("<h6>");
                    sb.append(titlePrefix);
                    sb.append("<a href=\"");
                    sb.append(linkurl);
                    sb.append("\" title=\"" + rs.getString(1) + "\" target=\"_blank\">");
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("<font color=\"");
                        sb.append(rs.getString(5));
                        sb.append("\">");
                    }
                    sb.append(StringUtils.getTopic(rs.getString(1), charMax));
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("</font>");
                    }
                    sb.append("</a></h6>");
                }
                sb.append("</li>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgsDivDesc(int categoryId, int rowsNum, int showTitle, String sort, int charMax, String titlePrefix, int ImgW, int ImgH, int getChilds, int showBorder, String ArticleAttr) {
        int retNum = rowsNum;
        StringBuffer sb = new StringBuffer(512);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int databaseType = DBUtils.getDatabaseType();
        sql.append("select");
        if (databaseType == 11) {
            sql.append(" top " + retNum);
        } else if (databaseType == 14) {
            sql.append(" FIRST " + retNum);
        }
        sql.append(" Title,IsOutLink,OutLinkUrl,SavePath,TitleColor,Photo,Summary from t_article where Checked=1");
        if (ArticleAttr.equalsIgnoreCase("Images")) {
            sql.append(" and Images=1");
        } else if (ArticleAttr.equalsIgnoreCase("Top1")) {
            sql.append(" and Top1=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToHot")) {
            sql.append(" and ToHot=1");
        } else if (ArticleAttr.equalsIgnoreCase("Recommend")) {
            sql.append(" and Recommend=1");
        } else if (ArticleAttr.equalsIgnoreCase("ToTop")) {
            sql.append(" and ToTop=1");
        }
        if (categoryId > 0) {
            sql.append(" and (CategoryId=" + categoryId);
            if (getChilds == 1) {
                sql.append(" or ParentId=" + categoryId);
            }
            sql.append(")");
        }
        if (databaseType == 10) {
            sql.append(" and ROWNUM<=").append(retNum);
        }
        sql.append(" order by " + sort + " desc");
        if (databaseType == 15) {
            sql.append(" limit 0," + retNum);
        } else if (databaseType == 16) {
            sql.append(" limit " + retNum);
        } else if (databaseType == 12) {
            sql.append(" fetch first " + retNum + " rows only ");
        }
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            log.debug((Object)("get imgs div:" + sql.toString()));
            for (int rows = 0; rows < rowsNum && rs.next(); ++rows) {
                String linkurl = "";
                linkurl = rs.getInt(2) == 0 ? url + contextPath + rs.getString(4) : rs.getString(3);
                sb.append("<dl>\n");
                sb.append("<dt>");
                sb.append("<a href=\"");
                sb.append(linkurl);
                sb.append("\" target=\"_blank\">");
                sb.append("<img src=\"");
                sb.append(rs.getString(6));
                sb.append("\" border=\"0\"");
                if (showBorder == 1) {
                    sb.append(" style=\"border:1px solid #000000;\"");
                }
                sb.append(" width=\"" + ImgW + "\"");
                sb.append(" height=\"" + ImgH + "\"");
                sb.append(" alt=\"" + rs.getString(1) + "\"");
                sb.append(" /></a>");
                sb.append("</dt>");
                sb.append("<dd>");
                if (showTitle == 1) {
                    sb.append("<h2>");
                    sb.append(titlePrefix);
                    sb.append("<a href=\"");
                    sb.append(linkurl);
                    sb.append("\" target=\"_blank\">");
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("<span style=\"color:");
                        sb.append(rs.getString(5));
                        sb.append("\">");
                    }
                    sb.append(rs.getString(1));
                    if (rs.getString(5) != null && !rs.getString(5).equals("")) {
                        sb.append("</span>");
                    }
                    sb.append("</a></h2>");
                }
                sb.append("<p>");
                sb.append(StringUtils.getTopic(rs.getString(7), charMax));
                sb.append("<a href=\"");
                sb.append(linkurl);
                sb.append("\" target=\"_blank\">");
                sb.append("\u8be6\u7ec6&gt;&gt;</a></p>");
                sb.append("</dd>");
                sb.append("</dl>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sql.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRelate(String keyword, int rowsNum, boolean isShowDate) {
        StringBuffer sb = new StringBuffer(512);
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        if (keyword == null || keyword.equals("")) {
            return "";
        }
        try {
            SearchQueryNoSql query = new SearchQueryNoSql();
            if (keyword != null && keyword.length() > 0) {
                query.setSearchString(keyword);
                query.setScopeInArticle(3);
            }
            query.setSortType(1);
            query.searchDocuments(0, rowsNum);
            Collection result = query.getArticleResult();
            log.debug((Object)("get relate article:" + keyword));
            for (DataField df : result) {
                boolean IsOutLink = false;
                sb.append("<li>\n");
                if (isShowDate) {
                    sb.append("<span class=\"col_right\">");
                    sb.append(df.getFieldValue("ModiTime").substring(5, 10));
                    sb.append("</span>");
                }
                sb.append("<a href=\"");
                if (IsOutLink) {
                    sb.append(df.getFieldValue("OutLinkUrl"));
                } else {
                    sb.append(url + contextPath + df.getFieldValue("SavePath"));
                }
                sb.append("\" target=\"_blank\" title=\"");
                sb.append(df.getFieldValue("Title"));
                sb.append("\">");
                sb.append(df.getFieldValue("Title"));
                sb.append("</a>");
                sb.append("</li>\n");
            }
        }
        catch (Exception e) {
            log.error((Object)"Sql Exception Error:", (Throwable)e);
        }
        return sb.toString();
    }
}

