/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class AskDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AskDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_ask order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int categoryid, int gradeid, int subjectid, String userid, String title, String content, String attach, Timestamp moditime, int hits, int paynum, int status) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_ask(CategoryId,GradeId,SubjectId,UserId,Title,Content,Attach,PubDate,Hits,ReplyUser,PayNum,Status,IsRecommend,IsPerfect) values(?,?,?,?,?,?,?,?,?,?,?,?,0,0)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, categoryid);
                ps.setInt(2, gradeid);
                ps.setInt(3, subjectid);
                ps.setString(4, userid);
                ps.setString(5, title);
                ps.setString(6, content);
                ps.setString(7, attach);
                ps.setTimestamp(8, moditime);
                ps.setInt(9, hits);
                ps.setString(10, "");
                ps.setInt(11, paynum);
                ps.setInt(12, status);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add ask error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(int id, int categoryid, int gradeid, int subjectid, String userid, String title, String content, String attach, Timestamp moditime, int hits, int paynum, int status) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_ask set CategoryId=?,GradeId=?,SubjectId=?,UserId=?,Title=?,Content=?,Attach=?,PubDate=?,Hits=?,ReplyUser=?,PayNum=?,Status=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, categoryid);
                ps.setInt(2, gradeid);
                ps.setInt(3, subjectid);
                ps.setString(4, userid);
                ps.setString(5, title);
                ps.setString(6, content);
                ps.setString(7, attach);
                ps.setTimestamp(8, moditime);
                ps.setInt(9, hits);
                ps.setString(10, "");
                ps.setInt(11, paynum);
                ps.setInt(12, status);
                ps.setInt(13, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod ask error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public Collection getList(int categoryid, int gradeid, int subjectid, int status, String key, int orderby, int isrecommend, int isperfect, int currentpage, int pagesize) {
        String ord = "id";
        if (orderby == 1) {
            ord = "Hits";
        }
        if (orderby == 2) {
            ord = "JoinNum";
        }
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT t_ask.id as eid,t_ask.Title as etitle,t_ask.UserId as tuid,t_ask.Attach,t_ask.PubDate,t_ask.Hits,ReplyUser,ReplyNum,PayNum,Status,t_category.Title as ctitle,t_edu_grade.Title as gtitle,t_edu_subject.Title as stitle FROM t_ask,t_category,t_edu_grade,t_edu_subject where t_ask.CategoryId=t_category.id  and t_ask.GradeId=t_edu_grade.id and t_ask.SubjectId=t_edu_subject.id");
            if (categoryid > 0) {
                sql.append(" and t_ask.CategoryId=" + categoryid);
            }
            if (gradeid > 0) {
                sql.append(" and t_ask.GradeId=" + gradeid);
            }
            if (subjectid > 0) {
                sql.append(" and t_ask.SubjectId=" + subjectid);
            }
            if (status >= 0) {
                sql.append(" and t_ask.Status=" + status);
            }
            if (isrecommend >= 0) {
                sql.append(" and t_ask.IsRecommend=" + isrecommend);
            }
            if (isperfect >= 0) {
                sql.append(" and t_ask.IsPerfect=" + isperfect);
            }
            if (key != null) {
                sql.append(" and t_ask.Title like '%" + key + "%'");
            }
            sql.append(" order by t_ask." + ord + " desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,UserId,Attach,PubDate,Hits,ReplyUser,ReplyNum,PayNum,Status,Category,Grade,Subject", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_ask WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_ask");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Title from t_ask");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField get(int id) {
        String fields = "CategoryId,GradeId,SubjectId,UserId,Title,Content,Attach,PubDate,Hits,ReplyUser,PayNum,Status";
        return this.getFirstData("select " + fields + " from t_ask where id=" + id, fields);
    }

    public DataField getShow(int id) {
        String fields = "UserId,Title,Content,Attach,PubDate,Hits,ReplyUser,PayNum,Status,CategoryId,GradeId,SubjectId";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t_ask.UserId,t_ask.Title,t_ask.Content,t_ask.Attach,t_ask.PubDate,Hits,ReplyUser,PayNum,Status,t_category.Title as ctitle,t_edu_grade.Title as gtitle,t_edu_subject.Title as stitle  FROM t_ask,t_category,t_edu_grade,t_edu_subject where t_ask.CategoryId=t_category.id  and t_ask.GradeId=t_edu_grade.id and t_ask.SubjectId=t_edu_subject.id and t_ask.id=" + id);
        return this.getFirstData(sql.toString(), fields);
    }

    public int getTotalCount(int categoryid, int gradeid, int subjectid, int status, String key, int isrecommend, int isperfect) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT  count(*) FROM t_ask,t_category where t_ask.CategoryId=t_category.id");
        if (categoryid > 0) {
            sql.append(" and t_ask.CategoryId=" + categoryid);
        }
        if (gradeid > 0) {
            sql.append(" and t_ask.GradeId=" + gradeid);
        }
        if (subjectid > 0) {
            sql.append(" and t_ask.SubjectId=" + subjectid);
        }
        if (status >= 0) {
            sql.append(" and t_ask.Status=" + status);
        }
        if (isrecommend >= 0) {
            sql.append(" and t_ask.IsRecommend=" + isrecommend);
        }
        if (isperfect >= 0) {
            sql.append(" and t_ask.IsPerfect=" + isperfect);
        }
        if (key != null) {
            sql.append(" and t_ask.Title like '%" + key + "%'");
        }
        return this.getDataCount(sql.toString());
    }

    public void batDel(String[] s) {
        this.bat("delete from t_ask where id=?", s);
    }

    public void batStatus(String[] s, int val) {
        this.bat("update t_ask set Status=" + val + " where id=?", s);
    }

    public void batRecommend(String[] s, int val) {
        this.bat("update t_ask set IsRecommend=" + val + " where id=?", s);
    }

    public void batPerfect(String[] s, int val) {
        this.bat("update t_ask set IsPerfect=" + val + " where id=?", s);
    }

    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_ask where id=" + id);
    }

    public void upHits(int id) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_ask set Hits=Hits+1 where id=" + id);
    }

    public void upStatus(int id, int val) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_ask set Status=" + val + " where id=" + id);
    }

    public void upReplyUser(int id, String userid) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_ask set ReplyUser='" + userid + "' where id=" + id);
    }

    public void upReplyNum(int id) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_ask set ReplyNum=ReplyNum+1 where id=" + id);
    }
}

