/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class DbImportDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(DbImportDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDbImport(int db_type, String db_driver, String db_host, String db_name, String db_username, String db_password, String db_table, String db_key, String db_order, String db_sql, int categoryid, int templateid, int default_status, String fields_map) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_dbimport(db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, db_type);
                ps.setString(2, db_driver);
                ps.setString(3, db_host);
                ps.setString(4, db_name);
                ps.setString(5, db_username);
                ps.setString(6, db_password);
                ps.setString(7, db_table);
                ps.setString(8, db_key);
                ps.setString(9, db_order);
                ps.setString(10, db_sql);
                ps.setInt(11, categoryid);
                ps.setInt(12, templateid);
                ps.setInt(13, default_status);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(14, (Reader)new StringReader(fields_map), fields_map.length());
                } else {
                    ps.setString(14, fields_map);
                }
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add dbimport error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modDbImport(int id, int db_type, String db_driver, String db_host, String db_name, String db_username, String db_password, String db_table, String db_key, String db_order, String db_sql, int categoryid, int templateid, int default_status, String fields_map) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_dbimport set db_type=?,db_driver=?,db_host=?,db_name=?,db_username=?,db_password=?,db_table=?,db_key=?,db_order=?,db_sql=?,categoryid=?,templateid=?,default_status=?,fields_map=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, db_type);
                ps.setString(2, db_driver);
                ps.setString(3, db_host);
                ps.setString(4, db_name);
                ps.setString(5, db_username);
                ps.setString(6, db_password);
                ps.setString(7, db_table);
                ps.setString(8, db_key);
                ps.setString(9, db_order);
                ps.setString(10, db_sql);
                ps.setInt(11, categoryid);
                ps.setInt(12, templateid);
                ps.setInt(13, default_status);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(14, (Reader)new StringReader(fields_map), fields_map.length());
                } else {
                    ps.setString(14, fields_map);
                }
                ps.setInt(15, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod dbimport error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delDbImport(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_dbimport where id=" + id);
    }

    public DataField getDbImport(int id) {
        return this.getFirstData("select db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map from t_dbimport where id=" + id, "db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_dbimport");
    }

    public Collection getDbImportList(int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_dbimport WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_dbimport");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_dbimport");
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_dbimport");
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_dbimport where id=?", s);
    }
}

