/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class EbookCommenDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(EbookCommenDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int objid, String author, String content, String ip, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_ebook_commen(ObjId,Author,Content,Ip,ModiTime) values(?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, objid);
                ps.setString(2, author);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(3, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(3, content);
                }
                ps.setString(4, ip);
                ps.setTimestamp(5, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add GuestBook error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(int id, String author, String content) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_ebook_commen set author=?,Content=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, author);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(2, content);
                }
                ps.setInt(3, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod GuestBook error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public DataField get(int id) {
        return this.getFirstData("select id,ObjId,Author,Content,Ip,ModiTime from t_ebook_commen where id=" + id, "id,ObjId,Author,Content,Ip,ModiTime");
    }

    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_ebook_commen where id=" + id);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_ebook_commen where id=?", s);
    }

    public void baRecommend(String[] s, int val) {
        this.bat("update t_ebook_commen set IsRecommend=" + val + " where id=?", s);
    }

    public Collection getListByLimit(int objid, int isrecommend, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("select t_ebook_commen.id as tid,t_ebook_commen.ObjId,t_ebook_commen.Author as tauthor,t_ebook_commen.Content as tcontent,t_ebook_commen.Ip as tip,t_ebook_commen.ModiTime as tmod,t_ebook.Title as dtilte from t_ebook_commen,t_ebook where t_ebook_commen.ObjId=t_ebook.id");
            if (objid > 0) {
                sql.append(" and t_ebook_commen.ObjId=" + objid);
            }
            if (isrecommend > 0) {
                sql.append(" and t_ebook_commen.IsRecommend=" + isrecommend);
            }
            sql.append(" order by t_ebook_commen.id desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,ObjId,Author,Content,Ip,ModiTime,DownTitle", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Author,Content,Ip,ModiTime FROM t_ebook_commen WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_ebook_commen where 1=1");
            if (objid > 0) {
                sql.append(" and ObjId=" + objid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (objid > 0) {
                sql.append(" and ObjId=" + objid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Author,Content,Ip,ModiTime");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Author,Content,Ip,ModiTime from t_ebook_commen where 1=1");
        if (objid > 0) {
            sql.append(" and ObjId=" + objid);
        }
        return this.getDataList_Limit_Normal(sql.toString(), "id,Author,Content,Ip,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(int objid) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_ebook_commen where 1=1");
        if (objid > 0) {
            sql.append(" and ObjId=");
            sql.append(objid);
        }
        return this.getDataCount(sql.toString());
    }
}

