/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;
import tot.util.StringUtils;

public class EduDownloadDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(EduDownloadDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_edu_download order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String title, String viewimg, int categoryid, int versionid, int gradeid, int subjectid, int infotype, float money, String content, String vtype, String vurl, Timestamp moditime, int isfree, String author, String filelen, String fcontent, int isdownload, int pubserverid, int ischeck, String userid, int isguestpub) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            int ParentId = DaoFactory.getCategoryDAO().getParentId(categoryid);
            String sql = "insert into t_edu_download(Title,ViewImg,CategoryId,VersionId,GradeId,SubjectId,InfoType,NeedMoney,Fdesc,Vtype,Vurl,ModiTime,IsFree,Author,FileLen,ParentId,Fcontent,IsDownload,PubServerId,IsCheck,UserId,IsGuestPub) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, viewimg);
                ps.setInt(3, categoryid);
                ps.setInt(4, versionid);
                ps.setInt(5, gradeid);
                ps.setInt(6, subjectid);
                ps.setInt(7, infotype);
                ps.setFloat(8, money);
                ps.setString(9, content);
                ps.setString(10, vtype);
                ps.setString(11, vurl);
                ps.setTimestamp(12, moditime);
                ps.setInt(13, isfree);
                ps.setString(14, author);
                ps.setString(15, filelen);
                ps.setInt(16, ParentId);
                ps.setString(17, fcontent);
                ps.setInt(18, isdownload);
                ps.setInt(19, pubserverid);
                ps.setInt(20, ischeck);
                ps.setString(21, userid);
                ps.setInt(22, isguestpub);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add edu download error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(int id, String title, String viewimg, int categoryid, int versionid, int gradeid, int subjectid, int infotype, float money, String content, String vtype, String vurl, Timestamp moditime, int isfree, String author, String filelen, String fcontent, int isdownload, int pubserverid, int ischeck, String userid) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            int ParentId = DaoFactory.getCategoryDAO().getParentId(categoryid);
            String sql = "update t_edu_download set Title=?,ViewImg=?,CategoryId=?,VersionId=?,GradeId=?,SubjectId=?,InfoType=?,NeedMoney=?,Fdesc=?,Vtype=?,Vurl=?,ModiTime=?,IsFree=?,Author=?,FileLen=?,ParentId=?,Fcontent=?,IsDownload=?,PubServerId=?,IsCheck=?,UserId=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, viewimg);
                ps.setInt(3, categoryid);
                ps.setInt(4, versionid);
                ps.setInt(5, gradeid);
                ps.setInt(6, subjectid);
                ps.setInt(7, infotype);
                ps.setFloat(8, money);
                ps.setString(9, content);
                ps.setString(10, vtype);
                ps.setString(11, vurl);
                ps.setTimestamp(12, moditime);
                ps.setInt(13, isfree);
                ps.setString(14, author);
                ps.setString(15, filelen);
                ps.setInt(16, ParentId);
                ps.setString(17, fcontent);
                ps.setInt(18, isdownload);
                ps.setInt(19, pubserverid);
                ps.setInt(20, ischeck);
                ps.setString(21, userid);
                ps.setInt(22, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod edu download error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_edu_download where id=" + id);
    }

    public void upHits(int id) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_edu_download set Hits=Hits+1 where id=" + id);
    }

    public Collection getList_Limit(int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, String key, int orderby, int ischeck, String userid, int isguestpub, int currentpage, int pagesize) {
        String ord = "id";
        if (orderby == 1) {
            ord = "Hits";
        }
        if (orderby == 2) {
            ord = "JoinNum";
        }
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT t_edu_download.id as eid,t_edu_download.Title as etitle,t_edu_download.Hits,t_edu_download.ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,t_category.Title as ctitle,t_edu_version.Title as vtitle,t_edu_grade.Title as gtitle,t_edu_subject.Title as stitle FROM t_edu_download,t_category,t_edu_version,t_edu_grade,t_edu_subject where t_edu_download.CategoryId=t_category.id and t_edu_download.VersionId=t_edu_version.id and t_edu_download.GradeId=t_edu_grade.id and t_edu_download.SubjectId=t_edu_subject.id ");
            if (categoryid > 0) {
                sql.append(" and t_edu_download.CategoryId=" + categoryid);
            }
            if (versionid > 0) {
                sql.append(" and t_edu_download.VersionId=" + versionid);
            }
            if (gradeid > 0) {
                sql.append(" and t_edu_download.GradeId=" + gradeid);
            }
            if (subjectid > 0) {
                sql.append(" and t_edu_download.SubjectId=" + subjectid);
            }
            if (infotype >= 0) {
                sql.append(" and t_edu_download.InfoType=" + infotype);
            }
            if (isfree >= 0) {
                sql.append(" and t_edu_download.IsFree=" + isfree);
            }
            if (isrecommend > 0) {
                sql.append(" and t_edu_download.IsRecommend=" + isrecommend);
            }
            if (key != null) {
                sql.append(" and t_edu_download.Title like '%" + key + "%'");
            }
            if (ischeck >= 0) {
                sql.append(" and t_edu_download.IsCheck=" + ischeck);
            }
            if (userid != null) {
                sql.append(" and t_edu_download.UserId like '%" + userid + "%'");
            }
            if (isguestpub >= 0) {
                sql.append(" and t_edu_download.IsGuestPub=" + isguestpub);
            }
            sql.append(" order by t_edu_download." + ord + " desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Hits,ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,CategoryTitle,VersionTitle,GradeTitle,SubjectTitle", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_edu_download WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_edu_download");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Title from t_edu_download");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title", pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getList(int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, String key, int orderby, int getchilds, int currentpage, int pagesize) {
        String ord = "id";
        if (orderby == 1) {
            ord = "Hits";
        }
        if (orderby == 2) {
            ord = "JoinNum";
        }
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT t_edu_download.id as eid,t_edu_download.Title as etitle,t_edu_download.Hits,ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,t_edu_download.ModiTime as emodtime,t_category.Title as ctitle FROM t_edu_download,t_category where t_edu_download.IsCheck=1 and t_edu_download.CategoryId=t_category.id ");
            if (categoryid > 0) {
                if (getchilds == 0) {
                    sql.append(" and t_edu_download.CategoryId=" + categoryid);
                } else {
                    sql.append(" and (t_edu_download.CategoryId=" + categoryid + " or t_edu_download.ParentId=" + categoryid + ")");
                }
            }
            if (versionid > 0) {
                sql.append(" and t_edu_download.VersionId=" + versionid);
            }
            if (gradeid > 0) {
                sql.append(" and t_edu_download.GradeId=" + gradeid);
            }
            if (subjectid > 0) {
                sql.append(" and t_edu_download.SubjectId=" + subjectid);
            }
            if (infotype >= 0) {
                sql.append(" and t_edu_download.InfoType=" + infotype);
            }
            if (isfree >= 0) {
                sql.append(" and t_edu_download.IsFree=" + isfree);
            }
            if (isrecommend > 0) {
                sql.append(" and t_edu_download.IsRecommend=" + isrecommend);
            }
            if (key != null) {
                sql.append(" and t_edu_download.Title like '%" + key + "%'");
            }
            sql.append(" order by t_edu_download." + ord + " desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Hits,ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,ModiTime,CategoryTitle", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_edu_download WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_edu_download");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Title from t_edu_download");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField get(int id) {
        String fields = "Title,ViewImg,CategoryId,VersionId,GradeId,SubjectId,InfoType,NeedMoney,Fdesc,Vtype,Vurl,ModiTime,IsFree,Hits,Author,FileLen,JoinNum,Fcontent,IsDownload,PubServerId,IsCheck,UserId,IsGuestPub";
        return this.getFirstData("select " + fields + " from t_edu_download where id=" + id, fields);
    }

    public DataField getShow(int id) {
        String fields = "Title,ViewImg,Author,FileLen,NeedMoney,Fdesc,InfoType,Vtype,Vurl,ModiTime,IsFree,Hits,JoinNum,Fcontent,IsDownload,IsGuestPub,CategoryId,CatalogId,VersionId,GradeId,SubjectId";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t_edu_download.Title as etitle,t_edu_download.ViewImg,Author,FileLen,NeedMoney,Fdesc,InfoType,Vtype,Vurl,t_edu_download.ModiTime as emoditime,t_edu_download.IsFree,Hits,JoinNum,Fcontent,IsDownload,IsGuestPub,t_category.Title as ctitle,t_category.id as cid,t_edu_version.Title as vtitle,t_edu_grade.Title as gtitle,t_edu_subject.Title as stitle  FROM t_edu_download,t_category,t_edu_version,t_edu_grade,t_edu_subject where t_edu_download.CategoryId=t_category.id  and t_edu_download.VersionId=t_edu_version.id and t_edu_download.GradeId=t_edu_grade.id and t_edu_download.SubjectId=t_edu_subject.id and t_edu_download.id=" + id);
        return this.getFirstData(sql.toString(), fields);
    }

    public int getTotalCount(int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, String key, int ischeck, String userid, int isguestpub) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT  count(*) FROM t_edu_download,t_category where t_edu_download.CategoryId=t_category.id");
        if (categoryid > 0) {
            sql.append(" and t_edu_download.CategoryId=" + categoryid);
        }
        if (versionid > 0) {
            sql.append(" and t_edu_download.VersionId=" + versionid);
        }
        if (gradeid > 0) {
            sql.append(" and t_edu_download.GradeId=" + gradeid);
        }
        if (subjectid > 0) {
            sql.append(" and t_edu_download.SubjectId=" + subjectid);
        }
        if (infotype >= 0) {
            sql.append(" and t_edu_download.InfoType=" + infotype);
        }
        if (isfree >= 0) {
            sql.append(" and t_edu_download.IsFree=" + isfree);
        }
        if (isrecommend > 0) {
            sql.append(" and t_edu_download.IsRecommend=" + isrecommend);
        }
        if (key != null) {
            sql.append(" and t_edu_download.Title like '%" + key + "%'");
        }
        if (ischeck >= 0) {
            sql.append(" and t_edu_download.IsCheck=" + ischeck);
        }
        if (userid != null) {
            sql.append(" and t_edu_download.UserId like '%" + userid + "%'");
        }
        if (isguestpub >= 0) {
            sql.append(" and t_edu_download.IsGuestPub=" + isguestpub);
        }
        return this.getDataCount(sql.toString());
    }

    public void batDel(String[] s) {
        this.bat("delete from t_edu_download where id=?", s);
    }

    public void batRecommend(String[] s, int val) {
        this.bat("update t_edu_download set IsRecommend=" + val + " where id=?", s);
    }

    public void batDownload(String[] s, int val) {
        this.bat("update t_edu_download set IsDownload=" + val + " where id=?", s);
    }

    public void remove(String[] s, int categoryid) {
        int ParentId = DaoFactory.getCategoryDAO().getParentId(categoryid);
        this.bat("update t_edu_download set CategoryId=" + categoryid + ",ParentId=" + ParentId + " where id=?", s);
    }

    public String getLabelList(int rowsNum, int charMax, String titlePrefix, int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, int sort, int showtime, int getchilds) {
        StringBuffer sb = new StringBuffer(512);
        String lurl = "edu";
        if (infotype == 2) {
            lurl = "game";
        }
        ArrayList list = (ArrayList)this.getList(categoryid, versionid, gradeid, subjectid, infotype, isfree, isrecommend, null, sort, getchilds, 1, rowsNum);
        for (DataField df : list) {
            int itype = Integer.parseInt(df.getFieldValue("InfoType"));
            sb.append("<li>");
            if (showtime == 1) {
                sb.append("<span class=\"col_right\">");
                sb.append(df.getFieldValue("ModiTime").substring(5, 10));
                sb.append("</span>");
            }
            sb.append(titlePrefix);
            sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"), charMax));
            sb.append("</a>");
            if (itype == 1) {
                sb.append(" <img src=\"/images/media.gif\" align=\"baseline\" />");
            }
            sb.append("</li>\n");
        }
        return sb.toString();
    }

    public String getImgLabelList(int imgw, int imgh, int showtitle, int rowsNum, int charMax, String titlePrefix, int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, int getchilds) {
        StringBuffer sb = new StringBuffer(512);
        String lurl = "edu";
        if (infotype == 2) {
            lurl = "game";
        }
        ArrayList list = (ArrayList)this.getList(categoryid, versionid, gradeid, subjectid, infotype, isfree, isrecommend, null, 0, getchilds, 1, rowsNum);
        for (DataField df : list) {
            sb.append("<li>");
            sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append("<img src=\"").append(df.getFieldValue("ViewImg")).append("\"");
            sb.append(" width=\"" + imgw + "\"");
            sb.append(" height=\"" + imgh + "\" border=\"0\" /></a>");
            if (showtitle == 1) {
                sb.append("<h6>");
                sb.append(titlePrefix);
                sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
                sb.append(df.getFieldValue("id"));
                sb.append("\">");
                sb.append(StringUtils.getTopic(df.getFieldValue("Title"), charMax));
                sb.append("</a>");
                sb.append("</h6>");
            }
            sb.append("</li>\n");
        }
        return sb.toString();
    }

    public String getImgLabelListDesc(int imgw, int imgh, int showtitle, int rowsNum, int charMax, String titlePrefix, int categoryid, int versionid, int gradeid, int subjectid, int infotype, int isfree, int isrecommend, int getchilds) {
        StringBuffer sql = new StringBuffer(512);
        String lurl = "edu";
        if (infotype == 2) {
            lurl = "game";
        }
        sql.append("SELECT t_edu_download.id as eid,t_edu_download.Title as etitle,t_edu_download.Hits,ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,t_category.Title as ctitle FROM t_edu_download,t_category where t_edu_download.CategoryId=t_category.id ");
        if (categoryid > 0) {
            if (getchilds == 0) {
                sql.append(" and t_edu_download.CategoryId=" + categoryid);
            } else {
                sql.append(" and t_edu_download.ParentId=" + categoryid);
            }
        }
        if (versionid > 0) {
            sql.append(" and t_edu_download.VersionId=" + versionid);
        }
        if (gradeid > 0) {
            sql.append(" and t_edu_download.GradeId=" + gradeid);
        }
        if (subjectid > 0) {
            sql.append(" and t_edu_download.SubjectId=" + subjectid);
        }
        if (infotype >= 0) {
            sql.append(" and t_edu_download.InfoType=" + infotype);
        }
        if (isfree >= 0) {
            sql.append(" and t_edu_download.IsFree=" + isfree);
        }
        if (isrecommend > 0) {
            sql.append(" and t_edu_download.IsRecommend=" + isrecommend);
        }
        sql.append(" order by t_edu_download.id desc");
        ArrayList list = (ArrayList)this.getDataList_mysqlLimit(sql.toString(), "id,Title,Hits,ViewImg,Author,FileLen,IsRecommend,JoinNum,InfoType,CategoryTitle", rowsNum, 0);
        StringBuffer sb = new StringBuffer(512);
        for (DataField df : list) {
            sb.append("<li>");
            sb.append("<span>");
            if (showtitle == 1) {
                sb.append("<h6>");
                sb.append(titlePrefix);
                sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
                sb.append(df.getFieldValue("id"));
                sb.append("\">");
                sb.append(df.getFieldValue("Title"));
                sb.append("</a>");
                sb.append("</h6>");
            }
            sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Fdesc"), charMax));
            sb.append("</a>");
            sb.append("</span>");
            sb.append("<a href=\"/" + lurl + "/show.jsp?id=");
            sb.append(df.getFieldValue("id"));
            sb.append("\">");
            sb.append("<img src=\"").append(df.getFieldValue("ViewImg")).append("\"");
            sb.append(" width=\"" + imgw + "\"");
            sb.append(" height=\"" + imgh + "\" border=\"0\" /></a>");
            sb.append("</li>\n");
        }
        return sb.toString();
    }
}

