/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class FetchDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(FetchDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFetch(String userid, Float fmoney, int fstatus, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_fetch(UserId,Fmoney,Fstatus,Fdate) values(?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, userid);
                ps.setFloat(2, fmoney.floatValue());
                ps.setInt(3, fstatus);
                ps.setTimestamp(4, moditime);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add fetch error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delFetch(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_fetch where id=" + id);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_fetch where id=?", s);
    }

    public void batStatus(String[] s, int val) {
        this.bat("update t_fetch set Fstatus=" + val + " where id=?", s);
    }

    public boolean updateStatus(int id, int val) throws ObjectNotFoundException, DatabaseException {
        return this.exe("update t_fetch set Fstatus=" + val + " where id=" + id);
    }

    public Collection getFetchList_Limit(int status, String dateStart, String dateEnd, int currentpage, int pagesize) {
        String fields = "id,UserId,Fmoney,Fstatus,Fdate";
        StringBuffer sql = new StringBuffer(512);
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select " + fields + " from t_fetch where Fstatus=" + status);
            if (dateStart != null && dateEnd != null) {
                sql.append(" and to_days(Fdate)>=to_days('").append(dateStart).append("') and to_days(Fdate)<=to_days('").append(dateEnd).append("')");
            }
            return this.getDataList_mysqlLimit(sql.toString(), fields, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            return this.getData(sql.toString(), fields);
        }
        return this.getDataList_Limit_Normal("select " + fields + " from t_fetch", fields, pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(int status, String dateStart, String dateEnd) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_fetch where Fstatus=" + status);
        if (dateStart != null && dateEnd != null) {
            sql.append(" and to_days(Fdate)>=to_days('").append(dateStart).append("') and to_days(Fdate)<=to_days('").append(dateEnd).append("')");
        }
        return this.getDataCount(sql.toString());
    }
}

