/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class FlinkDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(FlinkDaoImplJDBC.class);

    public int getLastId() {
        int returnValue = 0;
        String sql = null;
        DataField df = null;
        sql = "select id from t_flink order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFlink(String title, String url, String logo, int sortid, int linktype) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_flink(Title,Url,Logo,SortId,LinkType) values(?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                ps.setString(3, logo);
                ps.setInt(4, sortid);
                ps.setInt(5, linktype);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Flink error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modFlink(int id, String title, String url, String logo, int sortid, int linktype) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_flink set Title=?,Url=?,Logo=?,SortId=?,LinkType=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                ps.setString(3, logo);
                ps.setInt(4, sortid);
                ps.setInt(5, linktype);
                ps.setInt(6, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Flink error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delFlink(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_flink where id=" + id);
    }

    public Collection getFlinks(int linktype) {
        String sql = "select id,Title,Url,Logo,SortId,LinkType from t_flink where LinkType=" + linktype + " order by SortId asc";
        return this.getData(sql, "id,Title,Url,Logo,SortId,LinkType");
    }

    public Collection getFlinkList_Limit(int linktype, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("select id,Title,Url,Logo,SortId,LinkType from t_flink");
            if (linktype > 0) {
                sql.append(" where LinkType=" + linktype);
            }
            sql.append(" order by SortId asc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Url,Logo,SortId,LinkType", pagesize, (currentpage - 1) * pagesize);
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Title,Url,Logo,SortId,LinkType from t_flink");
        if (linktype > 0) {
            sql.append(" where LinkType=" + linktype);
        }
        sql.append(" order by SortId asc");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title,Url,Logo,SortId,LinkType", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getFlink(int id) {
        return this.getFirstData("select id,Title,Url,Logo,SortId,LinkType from t_flink where id=" + id, "id,Title,Url,Logo,SortId,LinkType");
    }

    public int getTotalCount(int linktype) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_flink");
        sql.append(" where LinkType=");
        sql.append(linktype);
        return this.getDataCount(sql.toString());
    }

    public String getLinkList(int rowsNum, int colsNum, int linktype, String itcolor1, String itcolor2) {
        StringBuffer sb = new StringBuffer(1024);
        ArrayList list = (ArrayList)this.getFlinks(linktype);
        Iterator iter = list.iterator();
        sb.append("<TABLE  class=\"linklist\" cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\n");
        for (int rows = 0; rows < rowsNum; ++rows) {
            if (rows % 2 == 0) {
                sb.append("<tr bgColor=" + itcolor1 + ">\n");
            } else {
                sb.append("<tr bgColor=" + itcolor2 + ">\n");
            }
            for (int cols = 0; cols < colsNum && iter.hasNext(); ++cols) {
                DataField df = (DataField)iter.next();
                sb.append("<TD><DIV align=center>\n");
                if (linktype == 0) {
                    sb.append("<A href=\"" + df.getFieldValue("Url") + "\" title=\"" + df.getFieldValue("Title") + "\" target=_blank>" + df.getFieldValue("Title") + "</A>\n");
                } else {
                    sb.append("<a href=\"" + df.getFieldValue("Url") + "\" target=\"_blank\"><img src=\"" + df.getFieldValue("Logo") + "\" width=\"88\" height=\"31\" border=\"0\" alt=\"" + df.getFieldValue("Title") + "\"></a>\n");
                }
                sb.append("</DIV></TD>\n");
            }
            sb.append("</tr>\n");
        }
        sb.append("</TABLE>\n");
        return sb.toString();
    }
}

