/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class GatherHisDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(GatherHisDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGatherHis(String title, String url, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_gatherhis(Title,Url,ModiTime) values(?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                ps.setTimestamp(3, moditime);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add GatherHis error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modGatherHis(int id, String title, String url, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_gatherhis set Title=?,Url=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                ps.setTimestamp(3, moditime);
                ps.setInt(4, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod GatherHis error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGathered(String url) {
        boolean returnValue;
        block6: {
            if (url == null) {
                return true;
            }
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = true;
            String sql = null;
            sql = "select * from t_gatherhis where Url=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, url);
                rs = ps.executeQuery();
                returnValue = rs.next();
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"get isGathered", (Throwable)e);
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public boolean delGatherHis(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_gatherhis where id=" + id);
    }

    public Collection getGatherHis() {
        String sql = "select id,Title,Url,ModiTime from t_gatherhis order by id asc";
        return this.getData(sql, "id,Title,Url,ModiTime");
    }

    public Collection getGatherHisList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select id,Title,Url,ModiTime from t_gatherhis order by id desc", "id,Title,Url,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " id, Title,Url, ModiTime FROM t_gatherhis WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_gatherhis ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return this.getData(sql, "id,Title,Url,ModiTime");
        }
        return this.getDataList_Limit_Normal("select id,Title,Url,ModiTime from t_gatherhis order by id desc", "id,Title,Url,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getGatherHis(int id) {
        return this.getFirstData("select id,Title,Url,ModiTime from t_gatherhis where id=" + id, "id,Title,Url,ModiTime");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_gatherhis");
    }

    public void batDel(String[] s) {
        this.bat("delete from t_gatherhis where id=?", s);
    }
}

