/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class GuestbookDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(GuestbookDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGuestBook(int objid, int typeid, String author, String content, String ip, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_gbook(ObjId,TypeId,Author,Content,Ip,ModiTime) values(?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, objid);
                ps.setInt(2, typeid);
                ps.setString(3, author);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(4, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(4, content);
                }
                ps.setString(5, ip);
                ps.setTimestamp(6, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add GuestBook error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modGuestBook(int id, String author, String content) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_gbook set author=?,Content=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, author);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(2, content);
                }
                ps.setInt(3, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod GuestBook error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public DataField getGuestBook(int id) {
        return this.getFirstData("select id,ObjId,TypeId,Author,Content,Ip,ModiTime from t_gbook where id=" + id, "id,ObjId,TypeId,Author,Content,Ip,ModiTime");
    }

    public boolean delGuestBook(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_gbook where id=" + id);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_gbook where id=?", s);
    }

    public Collection getGuestBookListByObj_Limit(int objid, int typeid, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_gbook where 1=1");
            if (objid > 0) {
                sql.append(" and ObjId=" + objid);
            }
            if (typeid > 0) {
                sql.append(" and TypeId=" + typeid);
            }
            return this.getDataList_mysqlLimit(sql.toString(), "id,Author,Content,Ip,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Author,Content,Ip,ModiTime FROM t_gbook WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_gbook where 1=1");
            if (objid > 0) {
                sql.append(" and ObjId=" + objid);
            }
            if (typeid > 0) {
                sql.append(" and TypeId=" + typeid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (objid > 0) {
                sql.append(" and ObjId=" + objid);
            }
            if (typeid > 0) {
                sql.append(" and TypeId=" + typeid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Author,Content,Ip,ModiTime");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Author,Content,Ip,ModiTime from t_gbook where 1=1");
        if (objid > 0) {
            sql.append(" and ObjId=" + objid);
        }
        if (typeid > 0) {
            sql.append(" and TypeId=" + typeid);
        }
        return this.getDataList_Limit_Normal(sql.toString(), "id,Author,Content,Ip,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(int objid, int typeid) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_gbook where 1=1");
        if (objid > 0) {
            sql.append(" and ObjId=");
            sql.append(objid);
        }
        if (typeid > 0) {
            sql.append(" and TypeId=");
            sql.append(typeid);
        }
        return this.getDataCount(sql.toString());
    }
}

