/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class KeywordsDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(KeywordsDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_keywords order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKeywords(String title, String url) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_keywords(Title,Url) values(?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Keywords error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modKeywords(int id, String title, String url) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_keywords set Title=?,Url=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, url);
                ps.setInt(3, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Keywords error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delKeywords(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_keywords where id=" + id);
    }

    public Collection getKeywords() {
        String sql = "select id,Title,Url from t_keywords order by id asc";
        return this.getData(sql, "id,Title,Url");
    }

    public Collection getKeywordsList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("select id,Title,Url from t_keywords");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Url", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title,Url FROM t_keywords WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_keywords");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title,Url");
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append("select id,Title,Url from t_keywords");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title,Url", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getKeywords(int id) {
        return this.getFirstData("select id,Title,Url from t_keywords where id=" + id, "id,Title,Url");
    }

    public int getTotalCount(int categoryid) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_keywords");
        return this.getDataCount(sql.toString());
    }

    public void batDel(String[] s) {
        this.bat("delete from t_keywords where id=?", s);
    }
}

