/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class LabelDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(LabelDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_label order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    public DataField getLabel(int id) {
        String fieldArr = "id,CategoryId,Title,Demons,Content,ModiTime";
        return this.getFirstData("select " + fieldArr + " from t_label where id=" + id, fieldArr);
    }

    public int getTotalCount(int categoryid) {
        String sql = "select count(*) from t_label";
        if (categoryid > 0) {
            sql = sql + " where CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLabel(int categoryid, String title, String demons, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_label(CategoryId,Title,Demons,Content,ModiTime) values(?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, categoryid);
                ps.setString(2, title);
                ps.setString(3, demons);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(4, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(4, content);
                }
                ps.setTimestamp(5, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Label error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modLabel(int id, int categoryid, String title, String dmons, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_label set CategoryId=?,Title=?,Demons=?,Content=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, categoryid);
                ps.setString(2, title);
                ps.setString(3, dmons);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(4, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(4, content);
                }
                ps.setTimestamp(5, moditime);
                ps.setInt(6, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Label error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delLabel(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_label where id=" + id);
    }

    public String getContent(int id) {
        DataField df = this.getFirstData("select Content from t_label where id=" + id, "Content");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Content");
        }
        return returnValue;
    }

    public Collection getLabelByCategory(int categoryid) {
        String fieldStr = "id,Title,Content";
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(fieldStr);
        sql.append(" from t_label");
        if (categoryid > 0) {
            sql.append(" where CategoryId=0 or CategoryId=" + categoryid);
        }
        return this.getData(sql.toString(), fieldStr);
    }

    public Collection getLabelList_Limit(int categoryid, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_label WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_label");
            if (categoryid > 0) {
                sql.append(" where CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title,Demons,ModiTime");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select id,Title,Demons,ModiTime from t_label");
        if (categoryid > 0) {
            sql.append(" where CategoryId=");
            sql.append(categoryid);
        }
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getLabelSearchList_Limit(int categoryid, int sby, String key, int currentpage, int pagesize) {
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,Demons,ModiTime from t_label where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id, Title,Demons,ModiTime FROM t_label WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_label where 1=1");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid > 0) {
                sql.append(" and CategoryId=");
                sql.append(categoryid);
            }
            if (key != null) {
                sql.append(" and " + fields + " like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title,Demons,ModiTime");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select id,Title,Demons,ModiTime from t_label where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        if (key != null) {
            sql.append(" and " + fields + " like '%" + key + "%'");
        }
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(int categoryid, int sby, String key) {
        StringBuffer sql = new StringBuffer(512);
        String fields = "Title";
        if (sby == 1) {
            fields = "Demons";
        }
        sql.append("select count(*) from t_label where 1=1");
        if (categoryid > 0) {
            sql.append(" and CategoryId=");
            sql.append(categoryid);
        }
        if (key != null) {
            sql.append(" and " + fields + " like '%" + key + "%'");
        }
        return this.getDataCount(sql.toString());
    }
}

